/*
 * Decompiled with CFR 0.152.
 */
package com.gapps.library.utils;

import android.content.Context;
import android.graphics.Point;
import android.view.Display;
import android.view.WindowManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\u001a'\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006\u001a\u0012\u0010\u0007\u001a\u00020\u0001*\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a\f\u0010\n\u001a\u00020\u000b*\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"getHeight", "", "width", "", "height", "videoViewWidth", "(Ljava/lang/Float;Ljava/lang/Float;I)I", "getWidth", "Landroid/content/Context;", "widthRes", "isVideoUrl", "", "", "library_release"})
public final class ExtensionsKt {
    public static final int getWidth(@NotNull Context $this$getWidth, int widthRes) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)$this$getWidth, (String)"$this$getWidth");
        if (widthRes <= 0) {
            Object object = $this$getWidth.getSystemService("window");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager wm = (WindowManager)object;
            Display display = wm.getDefaultDisplay();
            Point size = new Point();
            display.getSize(size);
            n = size.x;
        } else {
            n = widthRes;
        }
        return n;
    }

    public static final int getHeight(@Nullable Float width, @Nullable Float height, int videoViewWidth) {
        int n;
        if (width == null || width.floatValue() <= 0.0f || height == null || height.floatValue() <= 0.0f) {
            n = videoViewWidth / 16 * 9;
        } else {
            float aspectRatio = width.floatValue() / height.floatValue();
            n = MathKt.roundToInt((float)((float)videoViewWidth / aspectRatio));
        }
        return n;
    }

    public static final boolean isVideoUrl(@Nullable String $this$isVideoUrl) {
        if ($this$isVideoUrl == null) {
            return false;
        }
        String string = "(?:http(?:s)?://)?(?:www.)?(?:m.)?(?:music.)?youtu(?:be|.be)?(?:\\.com)?(?:(?:\\w*.?://)?\\w*.?\\w*-?.?\\w*/(?:embed|e|v|watch|.*/)?\\??(?:feature=\\w*\\.?\\w*)?&?(?:v=)?/?)([\\w\\d_-]{11}).*|(?:http[s]?://)(?:w{3})?(?:player\\.)?rutube\\.ru/video/(?:embed/)?([A-Za-z0-9]+)[/]?(\\?.+)?|(?:http[s]?://)(?:w{3})?(?:player\\.)?vimeo\\.com/(?:[a-z]*/)*([0-9]{6,11})[?]?.*|(?:http[s]?://)?(?:www.|web.|m.)?(?:facebook|fb)?.com/(?:(?:video.php|watch?/)?\\?v=|.+/videos(?:/.+)?/)(\\d+)\\S*|(?:http[s]?://)?(?:www\\.)?(?:(?:dailymotion\\.com(?:/embed)?/video)|dai\\.ly)/([a-zA-Z0-9]+)(?:_[\\w_-]+)?|(?:http[s]?:\\/\\/)?(?:.+)?(?:wistia\\.(?:com|net)|wi\\.st)\\/(?:medias|embed|series)\\/(?:iframe\\/?)?(?:\\S+\\?\\S*wvideoid=)?([a-zA-Z0-9]+)\\S*|(?:http[s]?://)?(?:.+)?vzaar.com/?(?:videos/)?([a-zA-Z0-9]+)\\S*";
        boolean bl = false;
        return new Regex(string).matches((CharSequence)$this$isVideoUrl);
    }
}

