/*
 * Decompiled with CFR 0.152.
 */
package com.gapps.library.api;

import android.util.Log;
import com.gapps.library.api.ConstKt;
import com.gapps.library.api.VideoService;
import com.gapps.library.api.models.video.VideoPreviewModel;
import com.gapps.library.api.models.video.base.BaseVideoResponse;
import com.gapps.library.api.models.video.dailymotion.DailymotionResponse;
import com.gapps.library.api.models.video.facebook.FacebookResponse;
import com.gapps.library.api.models.video.hulu.HuluResponse;
import com.gapps.library.api.models.video.rutube.RutubeResponse;
import com.gapps.library.api.models.video.ted.TedTalksResponse;
import com.gapps.library.api.models.video.ustream.UstreamResponse;
import com.gapps.library.api.models.video.vimeo.VimeoResponse;
import com.gapps.library.api.models.video.vzaar.VzaarResponse;
import com.gapps.library.api.models.video.wistia.WistiaResponse;
import com.gapps.library.api.models.video.youtube.YoutubeResponse;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u000e0\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\nR\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lcom/gapps/library/api/VideoService;", "", "builder", "Lcom/gapps/library/api/VideoService$Builder;", "(Lcom/gapps/library/api/VideoService$Builder;)V", "client", "Lokhttp3/OkHttpClient;", "isLogEnabled", "", "(Lokhttp3/OkHttpClient;Z)V", "()Z", "videoHelper", "Lcom/gapps/library/api/VideoService$Helper;", "loadVideoPreview", "", "url", "", "callback", "Lkotlin/Function1;", "Lcom/gapps/library/api/models/video/VideoPreviewModel;", "Builder", "Helper", "library_release"})
public final class VideoService {
    private final Helper videoHelper;
    private final boolean isLogEnabled;

    public final void loadVideoPreview(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        if (this.isLogEnabled) {
            Log.i((String)"VideoService", (String)("loading url: " + url));
        }
        try {
            CharSequence charSequence = url;
            String string = "(?:http(?:s)?://)?(?:www.)?(?:m.)?(?:music.)?youtu(?:be|.be)?(?:\\.com)?(?:(?:\\w*.?://)?\\w*.?\\w*-?.?\\w*/(?:embed|e|v|watch|.*/)?\\??(?:feature=\\w*\\.?\\w*)?&?(?:v=)?/?)([\\w\\d_-]{11}).*";
            boolean bl = false;
            string = new Regex(string);
            bl = false;
            if (string.matches(charSequence)) {
                this.videoHelper.getYoutubeInfo(url, callback);
            } else {
                charSequence = url;
                string = "(?:http[s]?://)(?:w{3})?(?:player\\.)?vimeo\\.com/(?:[a-z]*/)*([0-9]{6,11})[?]?.*";
                bl = false;
                string = new Regex(string);
                bl = false;
                if (string.matches(charSequence)) {
                    this.videoHelper.getVimeoInfo(url, callback);
                } else {
                    charSequence = url;
                    string = "(?:http[s]?://)(?:w{3})?(?:player\\.)?rutube\\.ru/video/(?:embed/)?([A-Za-z0-9]+)[/]?(\\?.+)?";
                    bl = false;
                    string = new Regex(string);
                    bl = false;
                    if (string.matches(charSequence)) {
                        this.videoHelper.getRutubeInfo(url, callback);
                    } else {
                        charSequence = url;
                        string = "(?:http[s]?://)?(?:www.|web.|m.)?(?:facebook|fb)?.com/(?:(?:video.php|watch?/)?\\?v=|.+/videos(?:/.+)?/)(\\d+)\\S*";
                        bl = false;
                        string = new Regex(string);
                        bl = false;
                        if (string.matches(charSequence)) {
                            this.videoHelper.getFacebookInfo(url, callback);
                        } else {
                            charSequence = url;
                            string = "(?:http[s]?://)?(?:www\\.)?(?:(?:dailymotion\\.com(?:/embed)?/video)|dai\\.ly)/([a-zA-Z0-9]+)(?:_[\\w_-]+)?";
                            bl = false;
                            string = new Regex(string);
                            bl = false;
                            if (string.matches(charSequence)) {
                                this.videoHelper.getDailymotionInfo(url, callback);
                            } else {
                                charSequence = url;
                                string = "(?:http[s]?:\\/\\/)?(?:.+)?(?:wistia\\.(?:com|net)|wi\\.st)\\/(?:medias|embed|series)\\/(?:iframe\\/?)?(?:\\S+\\?\\S*wvideoid=)?([a-zA-Z0-9]+)\\S*";
                                bl = false;
                                string = new Regex(string);
                                bl = false;
                                if (string.matches(charSequence)) {
                                    this.videoHelper.getWistiaInfo(url, callback);
                                } else {
                                    charSequence = url;
                                    string = "(?:http[s]?://)?(?:.+)?vzaar.com/?(?:videos/)?([a-zA-Z0-9]+)\\S*";
                                    bl = false;
                                    string = new Regex(string);
                                    bl = false;
                                    if (string.matches(charSequence)) {
                                        this.videoHelper.getVzaarInfoUrl(url, callback);
                                    } else {
                                        charSequence = url;
                                        string = "(?:http[s]?:\\/\\/)?(?:www.)?hulu\\.(?:(?:com\\/\\S*(?:w(?:atch)?|eid)(?:\\/|=)?)|(?:tv\\/))?([a-zA-Z0-9]+)\\S*";
                                        bl = false;
                                        string = new Regex(string);
                                        bl = false;
                                        if (string.matches(charSequence)) {
                                            this.videoHelper.getHuluInfo(url, callback);
                                        } else {
                                            charSequence = url;
                                            string = "(?:http[s]?:\\/\\/)?(?:www\\.)?ustream.(?:com|tv)\\/(?:recorded|embed|channel)\\/?(?:([0-9]+)|(\\S+))(?:\\/\\S*)?";
                                            bl = false;
                                            string = new Regex(string);
                                            bl = false;
                                            if (string.matches(charSequence)) {
                                                this.videoHelper.getUstreamInfo(url, callback);
                                            } else {
                                                charSequence = url;
                                                string = "(?:http[s]?:\\/\\/)?(?:www|embed)?\\.?ted\\.com\\/talks\\/([_a-zA-Z0-9]+)\\S*";
                                                bl = false;
                                                string = new Regex(string);
                                                bl = false;
                                                if (string.matches(charSequence)) {
                                                    this.videoHelper.getTedTalksInfo(url, callback);
                                                } else {
                                                    callback.invoke((Object)VideoPreviewModel.Companion.error(url, "Err 1. Unknown video service. \nPlease, visit https://github.com/TalbotGooday/Android-Oembed-Video for more information about available services"));
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            callback.invoke((Object)VideoPreviewModel.Companion.error(url, "Err 1. Unknown video service. \nPlease, visit https://github.com/TalbotGooday/Android-Oembed-Video for more information about available services"));
        }
    }

    public final boolean isLogEnabled() {
        return this.isLogEnabled;
    }

    public VideoService(@NotNull OkHttpClient client, boolean isLogEnabled) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        this.isLogEnabled = isLogEnabled;
        this.videoHelper = new Helper(client);
    }

    public VideoService(@NotNull Builder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        this(builder.getOkHttpClient(), builder.isLogEnabled());
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u0019J\"\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u0019J\"\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u0019J\"\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u0019J\"\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u0019J\"\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u0019J:\u0010 \u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\u00172\b\u0010\"\u001a\u0004\u0018\u00010\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\"\u0010#\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u0019J\"\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u0019J\"\u0010%\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u0019J\"\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u0019J#\u0010'\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(JS\u0010)\u001a\u00020\u00152'\u0010*\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150,\u0012\u0006\u0012\u0004\u0018\u00010-0+\u00a2\u0006\u0002\b.2\u0018\b\u0002\u0010/\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0019H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00061"}, d2={"Lcom/gapps/library/api/VideoService$Helper;", "Lkotlinx/coroutines/CoroutineScope;", "client", "Lokhttp3/OkHttpClient;", "(Lcom/gapps/library/api/VideoService;Lokhttp3/OkHttpClient;)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "job", "Lkotlinx/coroutines/CompletableJob;", "fromJson", "Lcom/gapps/library/api/models/video/base/BaseVideoResponse;", "json", "Lcom/google/gson/JsonElement;", "type", "Ljava/lang/reflect/Type;", "getDailymotionInfo", "", "url", "", "callback", "Lkotlin/Function1;", "Lcom/gapps/library/api/models/video/VideoPreviewModel;", "getFacebookInfo", "getHuluInfo", "getRutubeInfo", "getTedTalksInfo", "getUstreamInfo", "getVideoInfo", "originalUrl", "finalUrl", "getVimeoInfo", "getVzaarInfoUrl", "getWistiaInfo", "getYoutubeInfo", "makeCallGetBody", "(Lokhttp3/OkHttpClient;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runSafeWithBlock", "action", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "onError", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)V", "library_release"})
    public final class Helper
    implements CoroutineScope {
        private final CompletableJob job;
        private Gson gson;
        private final OkHttpClient client;

        @NotNull
        public CoroutineContext getCoroutineContext() {
            return this.job.plus((CoroutineContext)Dispatchers.getMain());
        }

        public final void getUstreamInfo(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getVideoInfo(url, ConstKt.getUstreamInfoUrl(url), (Type)((Object)UstreamResponse.class), callback);
        }

        public final void getTedTalksInfo(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getVideoInfo(url, ConstKt.getTedTalksInfoUrl(url), (Type)((Object)TedTalksResponse.class), callback);
        }

        public final void getHuluInfo(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getVideoInfo(url, ConstKt.getHuluInfoUrl(url), (Type)((Object)HuluResponse.class), callback);
        }

        public final void getFacebookInfo(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getVideoInfo(url, ConstKt.getFacebookInfoUrl(url), (Type)((Object)FacebookResponse.class), callback);
        }

        public final void getDailymotionInfo(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getVideoInfo(url, ConstKt.getDailymotionInfoUrl(url), (Type)((Object)DailymotionResponse.class), callback);
        }

        public final void getWistiaInfo(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getVideoInfo(url, ConstKt.getWistiaInfoUrl(url), (Type)((Object)WistiaResponse.class), callback);
        }

        public final void getVzaarInfoUrl(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getVideoInfo(url, ConstKt.getVzaarInfoUrl(url), (Type)((Object)VzaarResponse.class), callback);
        }

        public final void getRutubeInfo(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getVideoInfo(url, ConstKt.getRutubeInfoUrl(url), (Type)((Object)RutubeResponse.class), callback);
        }

        public final void getVimeoInfo(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getVideoInfo(url, ConstKt.getVimeoInfoUrl(url), (Type)((Object)VimeoResponse.class), callback);
        }

        public final void getYoutubeInfo(@NotNull String url, @NotNull Function1<? super VideoPreviewModel, Unit> callback) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
            this.getVideoInfo(url, ConstKt.getYoutubeInfoUrl(url), (Type)((Object)YoutubeResponse.class), callback);
        }

        private final void getVideoInfo(String originalUrl, String finalUrl, Type type, Function1<? super VideoPreviewModel, Unit> callback) {
            if (finalUrl == null) {
                callback.invoke((Object)VideoPreviewModel.Companion.error(originalUrl, "Err 3. Can't get oEmbed url"));
                return;
            }
            this.runSafeWithBlock((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, finalUrl, callback, originalUrl, type, null){
                private CoroutineScope p$;
                Object L$0;
                Object L$1;
                Object L$2;
                int label;
                final /* synthetic */ Helper this$0;
                final /* synthetic */ String $finalUrl;
                final /* synthetic */ Function1 $callback;
                final /* synthetic */ String $originalUrl;
                final /* synthetic */ Type $type;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            $receiver = this.p$;
                            this.L$0 = $receiver;
                            this.label = 1;
                            v0 = this.this$0.makeCallGetBody(Helper.access$getClient$p(this.this$0), this.$finalUrl, (Continuation<? super JsonElement>)this);
                            if (v0 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            $receiver = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            if ((jsonBody = (JsonElement)v0) != null) break;
                            this.L$0 = $receiver;
                            this.L$1 = jsonBody;
                            this.label = 2;
                            v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                private CoroutineScope p$;
                                int label;
                                final /* synthetic */ getVideoInfo.1 this$0;

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            CoroutineScope $this$withContext = this.p$;
                                            this.this$0.$callback.invoke((Object)VideoPreviewModel.Companion.error(this.this$0.$originalUrl, "Err 2. Can't parse response \n---> Response is null"));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(2, continuation);
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)this);
                            if (v1 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl29
                        }
                        case 2: {
                            jsonBody = (JsonElement)this.L$1;
                            $receiver = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl29:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    try {
                        var5_9 = Helper.access$fromJson(this.this$0, jsonBody, this.$type).toPreview(this.$originalUrl);
                    }
                    catch (Exception e) {
                        var5_9 = VideoPreviewModel.Companion.error(this.$originalUrl, "Err 2. Can't parse response \n---> " + e.getLocalizedMessage());
                    }
                    result = var5_9;
                    this.L$0 = $receiver;
                    this.L$1 = jsonBody;
                    this.L$2 = result;
                    this.label = 3;
                    v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, result, null){
                        private CoroutineScope p$;
                        int label;
                        final /* synthetic */ getVideoInfo.1 this$0;
                        final /* synthetic */ VideoPreviewModel $result;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    CoroutineScope $this$withContext = this.p$;
                                    this.this$0.$callback.invoke((Object)this.$result);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                        {
                            this.this$0 = var1_1;
                            this.$result = videoPreviewModel;
                            super(2, continuation);
                        }

                        @NotNull
                        public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                            Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                            Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                            CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                            return function2;
                        }

                        public final Object invoke(Object object, Object object2) {
                            return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)this);
                    if (v2 == var7_2) {
                        return var7_2;
                    }
                    ** GOTO lbl51
                    {
                        case 3: {
                            result = (VideoPreviewModel)this.L$2;
                            jsonBody = (JsonElement)this.L$1;
                            $receiver = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl51:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = helper;
                    this.$finalUrl = string;
                    this.$callback = function1;
                    this.$originalUrl = string2;
                    this.$type = type;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(callback, originalUrl){
                final /* synthetic */ Function1 $callback;
                final /* synthetic */ String $originalUrl;

                public final void invoke(@Nullable String it) {
                    this.$callback.invoke((Object)VideoPreviewModel.Companion.error(this.$originalUrl, "Err 2. Can't parse response \n---> " + it));
                }
                {
                    this.$callback = function1;
                    this.$originalUrl = string;
                    super(1);
                }
            }));
        }

        private final void runSafeWithBlock(Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object> action, Function1<? super String, Unit> onError) {
            BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)this.getCoroutineContext(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(action, onError, null){
                private CoroutineScope p$;
                Object L$0;
                int label;
                final /* synthetic */ Function2 $action;
                final /* synthetic */ Function1 $onError;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$launch = this.p$;
                            this.L$0 = $this$launch;
                            this.label = 1;
                            Object object2 = this.$action.invoke((Object)$this$launch, (Object)((Object)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            Object object2;
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                object2 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Throwable error) {
                                error.printStackTrace();
                                Function1 function1 = this.$onError;
                                if (function1 == null) return Unit.INSTANCE;
                                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)error.getLocalizedMessage());
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$action = function2;
                    this.$onError = function1;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        static /* synthetic */ void runSafeWithBlock$default(Helper helper, Function2 function2, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = null;
            }
            helper.runSafeWithBlock((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)function2, (Function1<? super String, Unit>)function1);
        }

        @Nullable
        final /* synthetic */ Object makeCallGetBody(@NotNull OkHttpClient client, @NotNull String url, @NotNull Continuation<? super JsonElement> $completion) {
            return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JsonElement>, Object>(client, url, null){
                private CoroutineScope p$;
                int label;
                final /* synthetic */ OkHttpClient $client;
                final /* synthetic */ String $url;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            JsonElement jsonObject;
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$withContext = this.p$;
                            Response response = this.$client.newCall(new Request.Builder().url(this.$url).build()).execute();
                            Object object2 = response.body();
                            if (object2 == null || (object2 = object2.string()) == null) {
                                return null;
                            }
                            Object stringBody = object2;
                            JsonElement jsonElement = jsonObject = new JsonParser().parse((String)stringBody);
                            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"jsonObject");
                            return jsonElement.isJsonArray() ? jsonObject.getAsJsonArray().get(0) : jsonObject;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$client = okHttpClient;
                    this.$url = string;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super JsonElement>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private final BaseVideoResponse fromJson(JsonElement json, Type type) {
            Object object = this.gson.fromJson(json, type);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gson.fromJson(json, type)");
            return (BaseVideoResponse)object;
        }

        public Helper(OkHttpClient client) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            this.client = client;
            this.job = JobKt.Job$default(null, (int)1, null);
            this.gson = new GsonBuilder().setLenient().create();
        }

        public static final /* synthetic */ OkHttpClient access$getClient$p(Helper $this) {
            return $this.client;
        }

        public static final /* synthetic */ BaseVideoResponse access$fromJson(Helper $this, JsonElement json, Type type) {
            return $this.fromJson(json, type);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\tR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0013"}, d2={"Lcom/gapps/library/api/VideoService$Builder;", "", "()V", "isLogEnabled", "", "()Z", "setLogEnabled", "(Z)V", "<set-?>", "Lokhttp3/OkHttpClient;", "okHttpClient", "getOkHttpClient", "()Lokhttp3/OkHttpClient;", "build", "Lcom/gapps/library/api/VideoService;", "enableLog", "isEnabled", "httpClient", "client", "library_release"})
    public static final class Builder {
        @NotNull
        private OkHttpClient okHttpClient = new OkHttpClient();
        private boolean isLogEnabled;

        @NotNull
        public final OkHttpClient getOkHttpClient() {
            return this.okHttpClient;
        }

        public final boolean isLogEnabled() {
            return this.isLogEnabled;
        }

        public final void setLogEnabled(boolean bl) {
            this.isLogEnabled = bl;
        }

        @NotNull
        public final Builder httpClient(@NotNull OkHttpClient client) {
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.okHttpClient = client;
            return builder;
        }

        @NotNull
        public final Builder enableLog(boolean isEnabled) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.isLogEnabled = isEnabled;
            return builder;
        }

        @NotNull
        public final VideoService build() {
            return new VideoService(this);
        }
    }
}

