/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.cs.treccar_v2.read_data;

import edu.unh.cs.treccar_v2.Data;
import edu.unh.cs.treccar_v2.read_data.DeserializeData;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;

public class ReadDataTest {
    public static void usage() {
        System.out.println("Command line parameters: (header|pages|outlines|paragraphs) FILE");
        System.exit(-1);
    }

    public static void main(String[] args) throws Exception {
        String mode;
        System.setProperty("file.encoding", "UTF-8");
        if (args.length < 2) {
            ReadDataTest.usage();
        }
        if ((mode = args[0]).equals("header")) {
            String pagesFile = args[1];
            FileInputStream fileInputStream = new FileInputStream(new File(pagesFile));
            System.out.println(DeserializeData.getTrecCarHeader(fileInputStream));
            System.out.println();
        } else if (mode.equals("pages")) {
            String pagesFile = args[1];
            FileInputStream fileInputStream = new FileInputStream(new File(pagesFile));
            for (Data.Page page : DeserializeData.iterableAnnotations(fileInputStream)) {
                System.out.println(page);
                System.out.println();
            }
        } else if (mode.equals("outlines")) {
            String pagesFile = args[1];
            FileInputStream fileInputStream3 = new FileInputStream(new File(pagesFile));
            for (Data.Page page : DeserializeData.iterableAnnotations(fileInputStream3)) {
                for (List<Data.Section> sectionPath : page.flatSectionPaths()) {
                    System.out.println(Data.sectionPathId(page.getPageId(), sectionPath) + "   \t " + Data.sectionPathHeadings(sectionPath));
                }
                System.out.println();
            }
        } else if (mode.equals("paragraphs")) {
            String paragraphsFile = args[1];
            FileInputStream fileInputStream2 = new FileInputStream(new File(paragraphsFile));
            for (Data.Paragraph p : DeserializeData.iterableParagraphs(fileInputStream2)) {
                System.out.println(p);
                System.out.println();
            }
        } else {
            ReadDataTest.usage();
        }
    }
}

