/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.cs.treccar_v2.read_data;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Number;
import co.nstant.in.cbor.model.Special;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import edu.unh.cs.treccar_v2.Data;
import edu.unh.cs.treccar_v2.Header;
import edu.unh.cs.treccar_v2.read_data.CborFileTypeException;
import edu.unh.cs.treccar_v2.read_data.CborListWithHeaderIterator;
import edu.unh.cs.treccar_v2.read_data.CborRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DeserializeData {
    private static final List<String> SUPPORTED_RELEASES = Arrays.asList("trec-car v1.6", "trec-car v2.0", "TQA", "trec-car v2.1", "trec-car v2.2", "trec-car v2.3", "benchmarkY2test", "benchmarkY3train", "benchmarkY3test", "trec-car v2.4", "trec-car v2.5", "trec-car v2.6");
    private static final String SUPPORTED_RELEASES_STR = SUPPORTED_RELEASES.get(0) + " or " + SUPPORTED_RELEASES.get(1);

    private static void checkSupportedRelease(Header.TrecCarHeader header) {
        if (header == null) {
            System.err.println("WARNING! This method only supports releases " + SUPPORTED_RELEASES_STR + ", but this input has no release information. Please use an appropriate reader.");
        } else {
            String dataReleaseName = header.getProvenance().getDataReleaseName();
            if (!SUPPORTED_RELEASES.contains(dataReleaseName)) {
                System.err.println("WARNING! This file is of version " + dataReleaseName + ". However this method only supports releases " + SUPPORTED_RELEASES_STR + ". Please use an appropriate reader.");
            }
        }
    }

    private static void checkIsPagesOrOutlines(Header.TrecCarHeader header) {
        Header.FileType fileType;
        if (header != null && (fileType = header.getFileType()) != null && !Header.FileType.OutlinesFile.equals((Object)fileType) && !Header.FileType.PagesFile.equals((Object)fileType)) {
            throw new CborFileTypeException("This method only supports " + (Object)((Object)Header.FileType.PagesFile) + " or " + (Object)((Object)Header.FileType.OutlinesFile) + ", but input is of file type " + (Object)((Object)fileType) + ". Please use an appropriate reader.");
        }
    }

    private static void checkIsParagraphFile(Header.TrecCarHeader header) {
        Header.FileType fileType;
        if (header != null && (fileType = header.getFileType()) != null && !Header.FileType.ParagraphsFile.equals((Object)fileType)) {
            throw new CborFileTypeException("This method only supports " + (Object)((Object)Header.FileType.ParagraphsFile) + ", but input is of file type " + (Object)((Object)fileType) + ". Please use an appropriate reader.");
        }
    }

    @NotNull
    public static Iterator<Data.Page> iterAnnotations(InputStream inputStream) throws CborRuntimeException, CborFileTypeException {
        CborDecoder decode = new CborDecoder(inputStream);
        class PageIterator
        extends CborListWithHeaderIterator<Data.Page> {
            PageIterator(CborDecoder decoder) throws CborRuntimeException {
                super(decoder);
            }

            @Override
            protected Data.Page parseItem(DataItem dataItem) {
                return DeserializeData.pageFromCbor(dataItem);
            }
        }
        PageIterator pageIterator = new PageIterator(decode);
        Header.TrecCarHeader header = pageIterator.getHeader();
        DeserializeData.checkSupportedRelease(header);
        DeserializeData.checkIsPagesOrOutlines(header);
        return pageIterator;
    }

    public static Header.TrecCarHeader getTrecCarHeader(InputStream inputStream) {
        CborDecoder decode = new CborDecoder(inputStream);
        class PageIterator
        extends CborListWithHeaderIterator<Data.Page> {
            PageIterator(CborDecoder decoder) throws CborRuntimeException {
                super(decoder);
            }

            @Override
            protected Data.Page parseItem(DataItem dataItem) {
                return DeserializeData.pageFromCbor(dataItem);
            }
        }
        Header.TrecCarHeader header = new PageIterator(decode).getHeader();
        DeserializeData.checkSupportedRelease(header);
        return header;
    }

    public static Iterable<Data.Page> iterableAnnotations(final InputStream inputStream) throws CborRuntimeException, CborFileTypeException {
        return new Iterable<Data.Page>(){

            @Override
            @NotNull
            public Iterator<Data.Page> iterator() {
                return DeserializeData.iterAnnotations(inputStream);
            }
        };
    }

    public static Data.Page annotationAtOffset(InputStream inputStream, long offset) throws CborRuntimeException, IOException {
        inputStream.skip(offset);
        return DeserializeData.iterAnnotations(inputStream).next();
    }

    @NotNull
    public static Iterator<Data.Paragraph> iterParagraphs(InputStream inputStream) throws CborRuntimeException, CborFileTypeException {
        CborDecoder decode = new CborDecoder(inputStream);
        class ParagraphIterator
        extends CborListWithHeaderIterator<Data.Paragraph> {
            ParagraphIterator(CborDecoder decoder) throws CborRuntimeException {
                super(decoder);
            }

            @Override
            protected Data.Paragraph parseItem(DataItem dataItem) {
                return DeserializeData.paragraphFromCbor(dataItem);
            }
        }
        ParagraphIterator paragraphIterator = new ParagraphIterator(decode);
        DeserializeData.checkSupportedRelease(paragraphIterator.getHeader());
        DeserializeData.checkIsParagraphFile(paragraphIterator.getHeader());
        return paragraphIterator;
    }

    public static Iterable<Data.Paragraph> iterableParagraphs(final InputStream inputStream) throws CborRuntimeException, CborFileTypeException {
        return new Iterable<Data.Paragraph>(){

            @Override
            @NotNull
            public Iterator<Data.Paragraph> iterator() {
                return DeserializeData.iterParagraphs(inputStream);
            }
        };
    }

    private static ArrayList<Data.ItemWithFrequency<String>> getStringWithFrequencyArray(List<DataItem> dataItems) {
        ArrayList<Data.ItemWithFrequency<String>> result = new ArrayList<Data.ItemWithFrequency<String>>();
        for (DataItem dataItem : dataItems) {
            List pair = ((Array)dataItem).getDataItems();
            String item = ((UnicodeString)pair.get(0)).getString();
            int frequency = ((Number)pair.get(1)).getValue().intValue();
            result.add(new Data.ItemWithFrequency<String>(item, frequency));
        }
        return result;
    }

    private static ArrayList<String> getUnicodeArray(List<DataItem> resultArray) {
        ArrayList<String> result = new ArrayList<String>(resultArray.size());
        for (DataItem item : resultArray) {
            if (Special.BREAK.equals((Object)item)) break;
            String s = ((UnicodeString)item).getString();
            result.add(s);
        }
        return result;
    }

    private static ArrayList<String> getByteArray(List<DataItem> resultArray) {
        ArrayList<String> result = new ArrayList<String>(resultArray.size());
        for (DataItem item : resultArray) {
            if (Special.BREAK.equals((Object)item)) break;
            String s = new String(((ByteString)item).getBytes());
            result.add(s);
        }
        return result;
    }

    private static Data.PageType pageTypeFromCbor(DataItem dataItem) {
        DataItem tag = (DataItem)((Array)dataItem).getDataItems().get(0);
        int tagValue = ((UnsignedInteger)tag).getValue().intValue();
        return Data.PageType.fromInt(tagValue);
    }

    private static Data.PageMetadata pageMetadataFromCbor(DataItem dataItem) {
        DataItem tagArray;
        List outerArray = ((Array)dataItem).getDataItems();
        Data.PageMetadata pageMetadata = new Data.PageMetadata();
        for (int i = 0; i < outerArray.size() && !Special.BREAK.equals((Object)(tagArray = (DataItem)outerArray.get(i))); i += 2) {
            String s;
            ArrayList<Object> array;
            DataItem tag = (DataItem)((Array)tagArray).getDataItems().get(0);
            long tagValue = ((UnsignedInteger)tag).getValue().longValue();
            DataItem item = (DataItem)outerArray.get(i + 1);
            if (Special.BREAK.equals((Object)item)) {
                throw new RuntimeException("Illegal protocol when decoding page metadata. Tag is " + tag + " but item is BREAK.");
            }
            if (tagValue == 0L) {
                array = DeserializeData.getUnicodeArray(((Array)item).getDataItems());
                pageMetadata.getRedirectNames().addAll(array);
                continue;
            }
            if (tagValue == 1L) {
                array = DeserializeData.getUnicodeArray(((Array)item).getDataItems());
                pageMetadata.getDisambiguationNames().addAll(array);
                continue;
            }
            if (tagValue == 2L) {
                array = DeserializeData.getByteArray(((Array)item).getDataItems());
                pageMetadata.getDisambiguationIds().addAll(array);
                continue;
            }
            if (tagValue == 3L) {
                array = DeserializeData.getUnicodeArray(((Array)item).getDataItems());
                pageMetadata.getCategoryNames().addAll(array);
                continue;
            }
            if (tagValue == 4L) {
                array = DeserializeData.getByteArray(((Array)item).getDataItems());
                pageMetadata.getCategoryIds().addAll(array);
                continue;
            }
            if (tagValue == 5L) {
                array = DeserializeData.getByteArray(((Array)item).getDataItems());
                pageMetadata.getInlinkIds().addAll(array);
                continue;
            }
            if (tagValue == 6L) {
                array = DeserializeData.getUnicodeArray(((Array)item).getDataItems());
                for (String name : array) {
                    pageMetadata.getInlinkAnchors().add(new Data.ItemWithFrequency<String>(name, 1));
                }
                continue;
            }
            if (tagValue == 7L) {
                array = DeserializeData.getStringWithFrequencyArray(((Array)item).getDataItems());
                pageMetadata.getInlinkAnchors().addAll(array);
                continue;
            }
            if (tagValue == 8L) {
                s = ((UnicodeString)item).getString();
                pageMetadata.getWikiDataQid().add(s);
                continue;
            }
            if (tagValue == 9L) {
                s = ((UnicodeString)item).getString();
                pageMetadata.getSiteId().add(s);
                continue;
            }
            if (tagValue != 10L) continue;
            array = DeserializeData.getUnicodeArray(((Array)item).getDataItems());
            pageMetadata.getPageTags().addAll(array);
        }
        return pageMetadata;
    }

    private static Data.Page pageFromCbor(DataItem dataItem) {
        List array = ((Array)dataItem).getDataItems();
        assert (((DataItem)array.get(0)).getTag().getValue() == 0L);
        UnicodeString pageName = (UnicodeString)array.get(1);
        ByteString pageId = (ByteString)array.get(2);
        DataItem skeletons = (DataItem)array.get(3);
        Data.PageType pageType = Data.PageType.Article;
        Data.PageMetadata pageMetadata = null;
        if (array.size() > 4) {
            pageType = DeserializeData.pageTypeFromCbor((DataItem)array.get(4));
            pageMetadata = DeserializeData.pageMetadataFromCbor((DataItem)array.get(5));
        }
        return new Data.Page(pageName.getString(), new String(pageId.getBytes()), DeserializeData.pageSkeletonsFromCbor(skeletons), pageType, pageMetadata);
    }

    private static Data.Image imageFromCbor(DataItem imageUrlDataItem, DataItem skeletonDataItem) {
        UnicodeString imageUrl = (UnicodeString)imageUrlDataItem;
        return new Data.Image(imageUrl.getString(), DeserializeData.pageSkeletonsFromCbor(skeletonDataItem));
    }

    private static Data.ListItem listFromCbor(DataItem nestingLevelItem, DataItem paragraphItem) {
        UnsignedInteger nestingLevel = (UnsignedInteger)nestingLevelItem;
        return new Data.ListItem(nestingLevel.getValue().intValue(), DeserializeData.paragraphFromCbor(paragraphItem));
    }

    private static Data.Para paraFromCbor(DataItem dataItem) {
        return new Data.Para(DeserializeData.paragraphFromCbor(dataItem));
    }

    private static Data.Paragraph paragraphFromCbor(DataItem dataItem) {
        List array = ((Array)dataItem).getDataItems();
        assert (((DataItem)array.get(0)).getTag().getValue() == 0L);
        ByteString paraid = (ByteString)array.get(1);
        DataItem bodiesItem = (DataItem)array.get(2);
        return new Data.Paragraph(new String(paraid.getBytes()), DeserializeData.paraBodiesFromCbor(bodiesItem));
    }

    private static Data.InfoBox infoboxFromCbor(UnicodeString infoboxTitle, List<DataItem> keyValues) {
        ArrayList<Data.Entry<String, List<Data.PageSkeleton>>> entries = new ArrayList<Data.Entry<String, List<Data.PageSkeleton>>>();
        for (DataItem keyVal : keyValues) {
            DataItem value;
            if (Special.BREAK.equals((Object)keyVal)) break;
            List keyVal_ = ((Array)keyVal).getDataItems();
            DataItem key = (DataItem)keyVal_.get(0);
            String keyStr = ((UnicodeString)key).getString();
            DataItem values = (DataItem)keyVal_.get(1);
            ArrayList<Data.PageSkeleton> valueSkelList = new ArrayList<Data.PageSkeleton>();
            Iterator iterator = ((Array)values).getDataItems().iterator();
            while (iterator.hasNext() && !Special.BREAK.equals((Object)(value = (DataItem)iterator.next()))) {
                Data.PageSkeleton valueSkel = DeserializeData.pageSkeletonFromCbor(value);
                valueSkelList.add(valueSkel);
                boolean bl = true;
            }
            entries.add(new Data.Entry(keyStr, valueSkelList));
        }
        return new Data.InfoBox(infoboxTitle.getString(), entries);
    }

    private static Data.PageSkeleton pageSkeletonFromCbor(DataItem dataItem) {
        List array = ((Array)dataItem).getDataItems();
        switch (((UnsignedInteger)array.get(0)).getValue().intValue()) {
            case 0: {
                UnicodeString heading = (UnicodeString)array.get(1);
                ByteString headingId = (ByteString)array.get(2);
                return new Data.Section(heading.getString(), new String(headingId.getBytes()), DeserializeData.pageSkeletonsFromCbor((DataItem)array.get(3)));
            }
            case 1: {
                return DeserializeData.paraFromCbor((DataItem)array.get(1));
            }
            case 2: {
                return DeserializeData.imageFromCbor((DataItem)array.get(1), (DataItem)array.get(2));
            }
            case 3: {
                return DeserializeData.listFromCbor((DataItem)array.get(1), (DataItem)array.get(2));
            }
            case 4: {
                return DeserializeData.infoboxFromCbor((UnicodeString)array.get(1), ((Array)array.get(2)).getDataItems());
            }
        }
        throw new RuntimeException("pageSkeletonFromCbor found an unhandled case: " + array.toString());
    }

    private static List<Data.PageSkeleton> pageSkeletonsFromCbor(DataItem dataItem) {
        DataItem item;
        Array skeletons = (Array)dataItem;
        ArrayList<Data.PageSkeleton> result = new ArrayList<Data.PageSkeleton>();
        Iterator iterator = skeletons.getDataItems().iterator();
        while (iterator.hasNext() && !Special.BREAK.equals((Object)(item = (DataItem)iterator.next()))) {
            result.add(DeserializeData.pageSkeletonFromCbor(item));
        }
        return result;
    }

    private static List<Data.ParaBody> paraBodiesFromCbor(DataItem dataItem) {
        DataItem item;
        Array bodies = (Array)dataItem;
        ArrayList<Data.ParaBody> result = new ArrayList<Data.ParaBody>();
        Iterator iterator = bodies.getDataItems().iterator();
        while (iterator.hasNext() && !Special.BREAK.equals((Object)(item = (DataItem)iterator.next()))) {
            result.add(DeserializeData.paraBodyFromCbor(item));
        }
        return result;
    }

    private static Data.ParaBody paraBodyFromCbor(DataItem dataItem) {
        List array = ((Array)dataItem).getDataItems();
        switch (((UnsignedInteger)array.get(0)).getValue().intValue()) {
            case 0: {
                UnicodeString text = (UnicodeString)array.get(1);
                return new Data.ParaText(text.getString());
            }
            case 1: {
                List array_ = ((Array)array.get(1)).getDataItems();
                UnicodeString page = (UnicodeString)array_.get(1);
                ByteString pageId = (ByteString)array_.get(3);
                UnicodeString anchorText = (UnicodeString)array_.get(4);
                List linkSectionMaybe = ((Array)array_.get(2)).getDataItems();
                if (linkSectionMaybe.size() > 0) {
                    UnicodeString linkSection = (UnicodeString)linkSectionMaybe.get(0);
                    return new Data.ParaLink(page.getString(), new String(pageId.getBytes()), linkSection.getString(), anchorText.getString());
                }
                return new Data.ParaLink(page.getString(), new String(pageId.getBytes()), anchorText.getString());
            }
        }
        throw new RuntimeException("paraBodyFromCbor found an unhandled case: " + array.toString());
    }

    private static Header.FileType fileTypeFromCbor(DataItem dataItem) {
        List array = ((Array)dataItem).getDataItems();
        return Header.FileType.fromInt(((UnsignedInteger)array.get(0)).getValue().intValue());
    }

    public static Header.TrecCarHeader headerFromCbor(DataItem dataItem) throws Header.InvalidHeaderException {
        List array = ((Array)dataItem).getDataItems();
        if (array.size() != 3) {
            throw new Header.InvalidHeaderException();
        }
        try {
            String magicWord = ((UnicodeString)array.get(0)).getString();
            if (!Objects.equals(magicWord, "CAR")) {
                throw new Header.InvalidHeaderException();
            }
        }
        catch (ClassCastException e) {
            throw new Header.InvalidHeaderException();
        }
        Header.FileType fileType = DeserializeData.fileTypeFromCbor((DataItem)array.get(1));
        Header.Provenance provenance = DeserializeData.provenanceFromCbor((DataItem)array.get(2));
        return new Header.TrecCarHeader(fileType, provenance);
    }

    private static Header.Provenance provenanceFromCbor(DataItem dataItem) {
        DataItem item;
        List array = ((Array)dataItem).getDataItems();
        List siteProvenance = ((Array)array.get(1)).getDataItems();
        String dataReleaseName = ((UnicodeString)array.get(2)).getString();
        Header.Provenance provenance = new Header.Provenance(dataReleaseName);
        List comments = ((Array)array.get(3)).getDataItems();
        List transforms = ((Array)array.get(4)).getDataItems();
        Iterator iterator = siteProvenance.iterator();
        while (iterator.hasNext() && !Special.BREAK.equals((Object)(item = (DataItem)iterator.next()))) {
            provenance.getSiteProvenance().add(DeserializeData.siteProvenanceFromCbor(item));
        }
        iterator = comments.iterator();
        while (iterator.hasNext() && !Special.BREAK.equals((Object)(item = (DataItem)iterator.next()))) {
            provenance.getComments().add(((UnicodeString)item).getString());
        }
        iterator = transforms.iterator();
        while (iterator.hasNext() && !Special.BREAK.equals((Object)(item = (DataItem)iterator.next()))) {
            provenance.getTransforms().add(DeserializeData.transformFromCbor(item));
        }
        return provenance;
    }

    private static Header.SiteProvenance siteProvenanceFromCbor(DataItem dataItem) {
        DataItem item;
        List array = ((Array)dataItem).getDataItems();
        String provSiteId = ((UnicodeString)array.get(1)).getString();
        String language = ((UnicodeString)array.get(2)).getString();
        String sourceName = ((UnicodeString)array.get(3)).getString();
        List comments = ((Array)array.get(4)).getDataItems();
        Header.SiteProvenance siteProvenance = new Header.SiteProvenance(provSiteId, language, sourceName);
        Iterator iterator = comments.iterator();
        while (iterator.hasNext() && !Special.BREAK.equals((Object)(item = (DataItem)iterator.next()))) {
            siteProvenance.getSiteComments().add(((UnicodeString)item).getString());
        }
        return siteProvenance;
    }

    private static Header.Transform transformFromCbor(DataItem dataItem) {
        List array = ((Array)dataItem).getDataItems();
        String toolName = ((UnicodeString)array.get(1)).getString();
        String toolCommit = ((UnicodeString)array.get(2)).getString();
        return new Header.Transform(toolName, toolCommit);
    }
}

