/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.cs.treccar_v2.read_data;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Special;
import edu.unh.cs.treccar_v2.read_data.CborRuntimeException;
import java.util.Iterator;

public class CborDataItemIterator
implements Iterator<DataItem> {
    private CborDecoder decoder;
    private DataItem next;

    public CborDataItemIterator(CborDecoder decoder) throws CborRuntimeException {
        this.decoder = decoder;
        this.next = this.lowLevelNext();
    }

    private DataItem lowLevelNext() throws CborRuntimeException {
        try {
            DataItem dataItem = this.decoder.decodeNext();
            if (Special.BREAK.equals((Object)dataItem)) {
                return null;
            }
            return dataItem;
        }
        catch (CborException e) {
            throw new CborRuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public DataItem next() {
        DataItem current = this.next;
        this.next = this.lowLevelNext();
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("read-only");
    }
}

