/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.cs.treccar_v2.export;

import edu.unh.cs.treccar_v2.Data;
import edu.unh.cs.treccar_v2.read_data.DeserializeData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FullTextFromPages {
    private static List<String> recurseArticle(Data.PageSkeleton skel, String query) {
        if (skel instanceof Data.Section) {
            Data.Section section = (Data.Section)skel;
            String query2 = section.getHeading();
            ArrayList<String> result = new ArrayList<String>();
            for (Data.PageSkeleton child : section.getChildren()) {
                result.addAll(FullTextFromPages.recurseArticle(child, query + " " + query2));
            }
            return result;
        }
        if (skel instanceof Data.Para) {
            Data.Para para = (Data.Para)skel;
            Data.Paragraph paragraph = para.getParagraph();
            StringBuilder text = new StringBuilder();
            for (Data.ParaBody body : paragraph.getBodies()) {
                if (body instanceof Data.ParaLink) {
                    text.append(((Data.ParaLink)body).getAnchorText());
                }
                if (!(body instanceof Data.ParaText)) continue;
                text.append(((Data.ParaText)body).getText());
            }
            return Collections.singletonList(query + " " + text);
        }
        if (skel instanceof Data.Image) {
            return Collections.singletonList("");
        }
        if (skel instanceof Data.ListItem) {
            Data.Paragraph paragraph = ((Data.ListItem)skel).getBodyParagraph();
            StringBuilder text = new StringBuilder();
            for (Data.ParaBody body : paragraph.getBodies()) {
                if (body instanceof Data.ParaLink) {
                    text.append(((Data.ParaLink)body).getAnchorText());
                }
                if (!(body instanceof Data.ParaText)) continue;
                text.append(((Data.ParaText)body).getText());
            }
            if (text.length() > 10) {
                return Collections.singletonList(query + " " + text);
            }
            return Collections.emptyList();
        }
        if (skel instanceof Data.InfoBox) {
            Data.InfoBox box = (Data.InfoBox)skel;
            StringBuilder text = new StringBuilder();
            text.append("Infobox (" + box.getInfoboxType() + ") ");
            for (Data.Entry<String, List<Data.PageSkeleton>> entry : box.getEntries()) {
                if (entry.getValue().size() <= 0) continue;
                text.append(entry.getKey() + ": [");
                for (Data.PageSkeleton val : entry.getValue()) {
                    List<String> result = FullTextFromPages.recurseArticle(val, "");
                    for (String str : result) {
                        text.append(str + " ");
                    }
                }
                text.append("] ");
            }
            return Collections.singletonList(query + " " + text.toString());
        }
        throw new UnsupportedOperationException("not known skel " + skel);
    }

    public static void main(String[] args) throws FileNotFoundException {
        System.setProperty("file.encoding", "UTF-8");
        FileInputStream fileInputStream = new FileInputStream(new File(args[0]));
        for (Data.Page page : DeserializeData.iterableAnnotations(fileInputStream)) {
            String query = page.getPageName();
            ArrayList<String> result = new ArrayList<String>();
            for (Data.PageSkeleton skel : page.getSkeleton()) {
                result.addAll(FullTextFromPages.recurseArticle(skel, page.getPageName()));
            }
            for (String line : result) {
                System.out.println(line);
            }
        }
    }
}

