/*
 * Decompiled with CFR 0.152.
 */
package edu.unh.cs.treccar_v2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Data {
    public static String sectionPathId(String pageId, List<Section> sections) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(pageId);
        for (Section section : sections) {
            result.add(section.getHeadingId());
        }
        return StringUtils.join(result, (String)"/");
    }

    public static List<String> sectionPathHeadings(List<Section> sections) {
        ArrayList<String> result = new ArrayList<String>();
        for (Section section : sections) {
            result.add(section.heading);
        }
        return result;
    }

    public static final class ParaLink
    implements ParaBody {
        private final String linkSection;
        private final String pageId;
        private final String anchorText;
        private final String page;

        public ParaLink(String page, String pageId, String anchorText) {
            this.pageId = pageId;
            this.anchorText = anchorText;
            this.page = page;
            this.linkSection = "";
        }

        public ParaLink(String page, String pageId, String linkSection, String anchorText) {
            this.linkSection = linkSection;
            this.pageId = pageId;
            this.anchorText = anchorText;
            this.page = page;
        }

        public boolean hasLinkSection() {
            return this.linkSection != null && !Objects.equals(this.linkSection, "");
        }

        public String getLinkSection() {
            return this.linkSection;
        }

        public String getPageId() {
            return this.pageId;
        }

        public String getAnchorText() {
            return this.anchorText;
        }

        public String getPage() {
            return this.page;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParaLink)) {
                return false;
            }
            ParaLink paraLink = (ParaLink)o;
            if (this.getLinkSection() != null ? !this.getLinkSection().equals(paraLink.getLinkSection()) : paraLink.getLinkSection() != null) {
                return false;
            }
            if (this.getPageId() != null ? !this.getPageId().equals(paraLink.getPageId()) : paraLink.getPageId() != null) {
                return false;
            }
            if (this.getAnchorText() != null ? !this.getAnchorText().equals(paraLink.getAnchorText()) : paraLink.getAnchorText() != null) {
                return false;
            }
            return this.getPage() != null ? this.getPage().equals(paraLink.getPage()) : paraLink.getPage() == null;
        }

        public int hashCode() {
            int result = this.getLinkSection() != null ? this.getLinkSection().hashCode() : 0;
            result = 31 * result + (this.getPageId() != null ? this.getPageId().hashCode() : 0);
            result = 31 * result + (this.getAnchorText() != null ? this.getAnchorText().hashCode() : 0);
            result = 31 * result + (this.getPage() != null ? this.getPage().hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ParaLink{ page='" + this.page + '\'' + ", linkSection='" + this.linkSection + '\'' + ", pageId='" + this.pageId + '\'' + ", anchorText='" + this.anchorText + '\'' + '}';
        }
    }

    public static final class ParaText
    implements ParaBody {
        private final String text;

        public ParaText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "ParaText{text='" + this.text + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ParaText)) {
                return false;
            }
            ParaText paraText = (ParaText)o;
            return this.getText() != null ? this.getText().equals(paraText.getText()) : paraText.getText() == null;
        }

        public int hashCode() {
            return this.getText() != null ? this.getText().hashCode() : 0;
        }
    }

    public static final class Paragraph {
        private final String paraId;
        private final List<ParaBody> bodies;

        public Paragraph(String paraId, List<ParaBody> bodies) {
            this.paraId = paraId;
            this.bodies = bodies;
        }

        public String getParaId() {
            return this.paraId;
        }

        public List<ParaBody> getBodies() {
            return this.bodies;
        }

        public String toString() {
            return "Paragraph{paraId='" + this.paraId + '\'' + ", captionSkel=" + this.bodies + '}';
        }

        public String getTextOnly() {
            StringBuilder result = new StringBuilder();
            for (ParaBody body : this.bodies) {
                if (body instanceof ParaLink) {
                    result.append(((ParaLink)body).getAnchorText());
                    continue;
                }
                if (!(body instanceof ParaText)) continue;
                result.append(((ParaText)body).getText());
            }
            return result.toString();
        }

        public List<String> getEntitiesOnly() {
            ArrayList<String> result = new ArrayList<String>();
            for (ParaBody body : this.bodies) {
                if (!(body instanceof ParaLink)) continue;
                result.add(((ParaLink)body).getPage());
            }
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Paragraph)) {
                return false;
            }
            Paragraph paragraph = (Paragraph)o;
            return this.getParaId() != null ? this.getParaId().equals(paragraph.getParaId()) : paragraph.getParaId() == null;
        }

        public int hashCode() {
            return this.getParaId() != null ? this.getParaId().hashCode() : 0;
        }
    }

    public static final class InfoBox
    implements PageSkeleton {
        private final String infoboxType;
        private List<Entry<String, List<PageSkeleton>>> entries;

        public InfoBox(String infoboxType, List<Entry<String, List<PageSkeleton>>> entries) {
            this.infoboxType = infoboxType;
            this.entries = entries;
        }

        public String getInfoboxType() {
            return this.infoboxType;
        }

        public List<Entry<String, List<PageSkeleton>>> getEntries() {
            return this.entries;
        }

        public String toString() {
            return "InfoBox{infoboxType='" + this.infoboxType + '\'' + ", entries=" + this.entries + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InfoBox)) {
                return false;
            }
            InfoBox infoBox = (InfoBox)o;
            return Objects.equals(this.getInfoboxType(), infoBox.getInfoboxType()) && Objects.equals(this.getEntries(), infoBox.getEntries());
        }

        public int hashCode() {
            return Objects.hash(this.getInfoboxType(), this.getEntries());
        }
    }

    public static final class Entry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public String toString() {
            return "Entry{key=" + this.key + ", value=" + this.value + '}';
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException("Read-only entry");
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)o;
            return Objects.equals(this.getKey(), entry.getKey()) && Objects.equals(this.getValue(), entry.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getKey(), this.getValue());
        }
    }

    public static final class ListItem
    implements PageSkeleton {
        private final int nestingLevel;
        private final Paragraph bodyParagraph;

        public ListItem(int nestingLevel, Paragraph bodyParagraph) {
            this.nestingLevel = nestingLevel;
            this.bodyParagraph = bodyParagraph;
        }

        public int getNestingLevel() {
            return this.nestingLevel;
        }

        public Paragraph getBodyParagraph() {
            return this.bodyParagraph;
        }

        public String toString() {
            return "* " + this.bodyParagraph.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ListItem)) {
                return false;
            }
            ListItem listItem = (ListItem)o;
            if (this.getNestingLevel() != listItem.getNestingLevel()) {
                return false;
            }
            return this.getBodyParagraph() != null ? this.getBodyParagraph().equals(listItem.getBodyParagraph()) : listItem.getBodyParagraph() == null;
        }

        public int hashCode() {
            int result = this.getNestingLevel();
            result = 31 * result + (this.getBodyParagraph() != null ? this.getBodyParagraph().hashCode() : 0);
            return result;
        }
    }

    public static final class Image
    implements PageSkeleton {
        private final String imageUrl;
        private final List<PageSkeleton> captionSkel;

        public Image(String paraId, List<PageSkeleton> caption) {
            this.imageUrl = paraId;
            this.captionSkel = caption;
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public List<PageSkeleton> getCaptionSkel() {
            return this.captionSkel;
        }

        public String toString() {
            return "Image{imageUrl='" + this.imageUrl + '\'' + ", caption=" + this.captionSkel + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Image)) {
                return false;
            }
            Image image = (Image)o;
            if (this.getImageUrl() != null ? !this.getImageUrl().equals(image.getImageUrl()) : image.getImageUrl() != null) {
                return false;
            }
            return this.getCaptionSkel() != null ? this.getCaptionSkel().equals(image.getCaptionSkel()) : image.getCaptionSkel() == null;
        }

        public int hashCode() {
            int result = this.getImageUrl() != null ? this.getImageUrl().hashCode() : 0;
            result = 31 * result + (this.getCaptionSkel() != null ? this.getCaptionSkel().hashCode() : 0);
            return result;
        }
    }

    public static final class Para
    implements PageSkeleton {
        private final Paragraph paragraph;

        public Para(Paragraph paragraph) {
            this.paragraph = paragraph;
        }

        public Paragraph getParagraph() {
            return this.paragraph;
        }

        public String toString() {
            return "Para{paragraph=" + this.paragraph + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Para)) {
                return false;
            }
            Para para = (Para)o;
            return this.getParagraph() != null ? this.getParagraph().equals(para.getParagraph()) : para.getParagraph() == null;
        }

        public int hashCode() {
            return this.getParagraph() != null ? this.getParagraph().hashCode() : 0;
        }
    }

    public static interface ParaBody {
    }

    public static final class Section
    implements PageSkeleton {
        private final String heading;
        private final String headingId;
        private final List<PageSkeleton> children;
        private final List<Section> childSections;

        public Section(String heading, String headingId, List<PageSkeleton> children) {
            this.heading = heading;
            this.headingId = headingId;
            this.children = children;
            this.childSections = new ArrayList<Section>();
            for (PageSkeleton skel : children) {
                if (!(skel instanceof Section)) continue;
                this.childSections.add((Section)skel);
            }
        }

        public String getHeading() {
            return this.heading;
        }

        public String getHeadingId() {
            return this.headingId;
        }

        public List<PageSkeleton> getChildren() {
            return this.children;
        }

        public List<Section> getChildSections() {
            return this.childSections;
        }

        public String toString() {
            return "Section{heading='" + this.heading + '\'' + ", headingId='" + this.headingId + '\'' + ", children=" + this.children + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Section)) {
                return false;
            }
            Section section = (Section)o;
            if (this.getHeadingId() != null ? !this.getHeadingId().equals(section.getHeadingId()) : section.getHeadingId() != null) {
                return false;
            }
            return this.getChildren() != null ? this.getChildren().equals(section.getChildren()) : section.getChildren() == null;
        }

        public int hashCode() {
            int result = this.getHeadingId() != null ? this.getHeadingId().hashCode() : 0;
            result = 31 * result + (this.getChildren() != null ? this.getChildren().hashCode() : 0);
            return result;
        }
    }

    public static final class Page {
        private final String pageName;
        private final String pageId;
        private final List<PageSkeleton> skeleton;
        private final PageType pageType;
        private final ArrayList<Section> childSections;
        private final PageMetadata pageMetadata;

        public Page(String pageName, String pageId, List<PageSkeleton> skeleton, PageType pageType, PageMetadata pageMetadata) {
            this.pageName = pageName;
            this.pageId = pageId;
            this.skeleton = skeleton;
            this.pageType = pageType;
            this.childSections = new ArrayList();
            for (PageSkeleton skel : skeleton) {
                if (!(skel instanceof Section)) continue;
                this.childSections.add((Section)skel);
            }
            this.pageMetadata = pageMetadata;
        }

        public String getPageName() {
            return this.pageName;
        }

        public String getPageId() {
            return this.pageId;
        }

        public PageType getPageType() {
            return this.pageType;
        }

        public PageMetadata getPageMetadata() {
            return this.pageMetadata;
        }

        public List<PageSkeleton> getSkeleton() {
            return this.skeleton;
        }

        public ArrayList<Section> getChildSections() {
            return this.childSections;
        }

        private static List<List<Section>> flatSectionPaths_(List<Section> prefix, List<Section> headings) {
            ArrayList<List<Section>> result = new ArrayList<List<Section>>();
            for (Section heading : headings) {
                ArrayList<Section> newPrefix = new ArrayList<Section>();
                newPrefix.addAll(prefix);
                newPrefix.add(heading);
                if (heading.getChildSections().isEmpty()) {
                    result.add(newPrefix);
                    continue;
                }
                result.add(newPrefix);
                result.addAll(Page.flatSectionPaths_(newPrefix, heading.getChildSections()));
            }
            return result;
        }

        public List<List<Section>> flatSectionPaths() {
            return Page.flatSectionPaths_(Collections.emptyList(), this.childSections);
        }

        private static List<SectionPathParagraphs> flatSectionPathsParagraphs_(List<Section> prefix, List<PageSkeleton> skeletonList) {
            ArrayList<SectionPathParagraphs> result = new ArrayList<SectionPathParagraphs>();
            for (PageSkeleton skel : skeletonList) {
                if (skel instanceof Section) {
                    Section section = (Section)skel;
                    ArrayList<Section> newPrefix = new ArrayList<Section>();
                    newPrefix.addAll(prefix);
                    newPrefix.add(section);
                    if (!section.getChildren().isEmpty()) {
                        result.addAll(Page.flatSectionPathsParagraphs_(newPrefix, section.getChildren()));
                    }
                }
                if (!(skel instanceof Para)) continue;
                Paragraph paragraph = ((Para)skel).getParagraph();
                result.add(new SectionPathParagraphs(prefix, paragraph));
            }
            return result;
        }

        public List<SectionPathParagraphs> flatSectionPathsParagraphs() {
            return Page.flatSectionPathsParagraphs_(Collections.emptyList(), this.getSkeleton());
        }

        public String toString() {
            return "Page{pageName='" + this.pageName + '\'' + "\n, pageMetadata=" + this.pageMetadata + "\n, skeleton=" + this.skeleton + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Page)) {
                return false;
            }
            Page page = (Page)o;
            if (this.getPageId() != null ? !this.getPageId().equals(page.getPageId()) : page.getPageId() != null) {
                return false;
            }
            return this.getSkeleton() != null ? this.getSkeleton().equals(page.getSkeleton()) : page.getSkeleton() == null;
        }

        public int hashCode() {
            int result = this.getPageId() != null ? this.getPageId().hashCode() : 0;
            result = 31 * result + (this.getSkeleton() != null ? this.getSkeleton().hashCode() : 0);
            return result;
        }

        public static class SectionPathParagraphs {
            private final List<Section> sectionPath;
            private final Paragraph paragraph;

            public SectionPathParagraphs(List<Section> sectionPath, Paragraph paragraph) {
                this.sectionPath = sectionPath;
                this.paragraph = paragraph;
            }

            public List<Section> getSectionPath() {
                return this.sectionPath;
            }

            public Paragraph getParagraph() {
                return this.paragraph;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                SectionPathParagraphs that = (SectionPathParagraphs)o;
                if (this.sectionPath != null ? !this.sectionPath.equals(that.sectionPath) : that.sectionPath != null) {
                    return false;
                }
                return this.paragraph != null ? this.paragraph.equals(that.paragraph) : that.paragraph == null;
            }

            public int hashCode() {
                int result = this.sectionPath != null ? this.sectionPath.hashCode() : 0;
                result = 31 * result + (this.paragraph != null ? this.paragraph.hashCode() : 0);
                return result;
            }

            public String toString() {
                return "SectionPathParagraphs{sectionPath=" + this.sectionPath + ", paragraph=" + this.paragraph + '}';
            }
        }
    }

    public static interface PageSkeleton {
    }

    public static final class PageMetadata {
        private final ArrayList<String> redirectNames;
        private final ArrayList<String> disambiguationNames;
        private final ArrayList<String> disambiguationIds;
        private final ArrayList<String> categoryNames;
        private final ArrayList<String> categoryIds;
        private final ArrayList<String> inlinkIds;
        private final ArrayList<ItemWithFrequency<String>> inlinkAnchors;
        private final ArrayList<String> wikiDataQid;
        private final ArrayList<String> siteId;
        private final ArrayList<String> pageTags;

        public PageMetadata(ArrayList<String> redirectNames, ArrayList<String> disambiguationNames, ArrayList<String> disambiguationIds, ArrayList<String> categoryNames, ArrayList<String> categoryIds, ArrayList<String> inlinkIds, ArrayList<ItemWithFrequency<String>> inlinkAnchors, ArrayList<String> wikiDataQid, ArrayList<String> siteId, ArrayList<String> pageTags) {
            this.redirectNames = redirectNames;
            this.disambiguationNames = disambiguationNames;
            this.disambiguationIds = disambiguationIds;
            this.categoryNames = categoryNames;
            this.categoryIds = categoryIds;
            this.inlinkIds = inlinkIds;
            this.inlinkAnchors = inlinkAnchors;
            this.wikiDataQid = wikiDataQid;
            this.siteId = siteId;
            this.pageTags = pageTags;
        }

        public PageMetadata() {
            this.redirectNames = new ArrayList();
            this.disambiguationNames = new ArrayList();
            this.disambiguationIds = new ArrayList();
            this.categoryNames = new ArrayList();
            this.categoryIds = new ArrayList();
            this.inlinkIds = new ArrayList();
            this.inlinkAnchors = new ArrayList();
            this.wikiDataQid = new ArrayList();
            this.siteId = new ArrayList();
            this.pageTags = new ArrayList();
        }

        public ArrayList<String> getRedirectNames() {
            return this.redirectNames;
        }

        public ArrayList<String> getDisambiguationNames() {
            return this.disambiguationNames;
        }

        public ArrayList<String> getDisambiguationIds() {
            return this.disambiguationIds;
        }

        public ArrayList<String> getCategoryNames() {
            return this.categoryNames;
        }

        public ArrayList<String> getCategoryIds() {
            return this.categoryIds;
        }

        public ArrayList<String> getInlinkIds() {
            return this.inlinkIds;
        }

        public ArrayList<ItemWithFrequency<String>> getInlinkAnchors() {
            return this.inlinkAnchors;
        }

        public ArrayList<String> getWikiDataQid() {
            return this.wikiDataQid;
        }

        public ArrayList<String> getSiteId() {
            return this.siteId;
        }

        public ArrayList<String> getPageTags() {
            return this.pageTags;
        }

        public String toString() {
            return "PageMetadata{redirectNames=" + this.redirectNames + "\n, disambiguationNames=" + this.disambiguationNames + "\n, disambiguationIds=" + this.disambiguationIds + "\n, categoryNames=" + this.categoryNames + "\n, categoryIds=" + this.categoryIds + "\n, inlinkIds=" + this.inlinkIds + "\n, inlinkAnchors=" + this.inlinkAnchors + "\n, wikiDataQid=" + this.wikiDataQid + "\n, siteId=" + this.siteId + "\n, pageTags=" + this.pageTags + '}';
        }
    }

    public static final class ItemWithFrequency<Item> {
        private Item item;
        private int frequency;

        public ItemWithFrequency(Item item, int frequency) {
            this.item = item;
            this.frequency = frequency;
        }

        public Item getItem() {
            return this.item;
        }

        public int getFrequency() {
            return this.frequency;
        }

        public String toString() {
            return "(" + this.item + ", " + this.frequency + ')';
        }
    }

    public static enum PageType {
        Article(0),
        Category(1),
        Disambiguation(2),
        Redirect(3);

        private int value;
        private static PageType[] values;

        private PageType(int value) {
            this.value = value;
        }

        public static PageType fromInt(int i) {
            if (values == null) {
                values = PageType.values();
            }
            return values[i];
        }

        static {
            values = null;
        }
    }
}

