/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.design.internal.NavigationMenuView;
import android.support.v7.view.ContextThemeWrapper;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.animation.AnimationUtils;
import com.tr4android.support.extension.drawable.RotationTransitionDrawable;
import com.tr4android.support.extension.internal.AccountAdapter;
import com.tr4android.support.extension.internal.AccountUtils;
import com.tr4android.support.extension.internal.IAccount;
import com.tr4android.support.extension.utils.ThemeUtils;
import com.tr4android.support.extension.widget.CircleImageView;
import java.util.ArrayList;
import java.util.List;

public class AccountHeaderView
extends RelativeLayout {
    private static final String LOG_TAG = "AccountHeaderView";
    private NavigationMenuView mNavigationMenuView;
    private ViewGroup mParent;
    private RecyclerView.Adapter mMenuAdapter;
    private AccountAdapter mAccountListAdapter;
    private boolean mIsShowingAccountList;
    private View.OnClickListener mShowAccountClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (AccountHeaderView.this.mIsShowingAccountList) {
                AccountHeaderView.this.hideAccountList();
            } else {
                AccountHeaderView.this.showAccountList();
            }
        }
    };
    private OnAccountSelectedListener mListener;
    private CircleImageView mPrimaryIconView;
    private CircleImageView mSecondaryFirstIconView;
    private CircleImageView mSecondarySecondIconView;
    private TextView mNameView;
    private TextView mEmailView;
    private ImageView mDropdownView;
    private final RotationTransitionDrawable mDropdownDrawable;

    public AccountHeaderView(Context context) {
        this(context, null);
    }

    public AccountHeaderView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AccountHeaderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super((Context)new ContextThemeWrapper(context, R.style.Widget_Design_AccountHeaderView), attrs, defStyleAttr);
        if (this.getBackground() == null) {
            this.setBackgroundColor(ThemeUtils.getThemeAttrColor(context, R.attr.colorPrimary));
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AccountHeaderView, defStyleAttr, 0);
        boolean mAddAccountEnabled = a.getBoolean(R.styleable.AccountHeaderView_accountHeaderAddEnabled, true);
        boolean mManageAccountEnabled = a.getBoolean(R.styleable.AccountHeaderView_accountHeaderManageEnabled, true);
        boolean mCheckableAccountsEnabled = a.getBoolean(R.styleable.AccountHeaderView_accountHeaderCheckableAccountsEnabled, false);
        a.recycle();
        LayoutInflater.from((Context)context).inflate(R.layout.appcompat_extension_account_header, (ViewGroup)this, true);
        this.mAccountListAdapter = new AccountAdapter(new ArrayList<IAccount>(), this, mAddAccountEnabled, mManageAccountEnabled, mCheckableAccountsEnabled);
        this.mPrimaryIconView = (CircleImageView)this.findViewById(R.id.account_header_icon_primary);
        this.mSecondaryFirstIconView = (CircleImageView)this.findViewById(R.id.account_header_icon_secondary_first);
        this.mSecondaryFirstIconView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountHeaderView.this.handleAccountClick(1);
            }
        });
        this.mSecondarySecondIconView = (CircleImageView)this.findViewById(R.id.account_header_icon_secondary_second);
        this.mSecondarySecondIconView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountHeaderView.this.handleAccountClick(2);
            }
        });
        this.mNameView = (TextView)this.findViewById(R.id.account_header_text_name);
        this.mEmailView = (TextView)this.findViewById(R.id.account_header_text_email);
        this.mDropdownView = (ImageView)this.findViewById(R.id.account_header_dropdown);
        this.mDropdownDrawable = new RotationTransitionDrawable(this.mDropdownView.getDrawable());
        this.mDropdownDrawable.setMaxRotation(-180.0f);
        this.mDropdownDrawable.setStartInterpolator(AnimationUtils.ACCELERATE_DECELERATE_INTERPOLATOR);
        this.mDropdownDrawable.setReverseInterpolator(AnimationUtils.ACCELERATE_DECELERATE_INTERPOLATOR);
        this.mDropdownView.setImageDrawable((Drawable)this.mDropdownDrawable);
        this.mDropdownView.setOnClickListener(this.mShowAccountClickListener);
    }

    public void handleAccountClick(int position) {
        this.hideAccountList();
        int count = this.mAccountListAdapter.getItemCount();
        if (position < this.mAccountListAdapter.getAccountCount()) {
            IAccount selectedAccount = this.mAccountListAdapter.get(position);
            boolean makePrimary = true;
            if (this.mListener != null) {
                makePrimary = this.mListener.onAccountSelected(selectedAccount);
            }
            if (makePrimary) {
                this.switchPrimaryAccount(selectedAccount);
            }
        } else if (position == count - 1 && this.mAccountListAdapter.isAccountManageEnabled()) {
            if (this.mListener != null) {
                this.mListener.onAccountManageSelected();
            }
        } else if (this.mListener != null) {
            this.mListener.onAccountAddSelected();
        }
    }

    public void handleAccountCheck(int position, boolean isChecked) {
        IAccount checkedAccount = this.mAccountListAdapter.get(position);
        if (this.mListener != null) {
            this.mListener.onAccountChecked(checkedAccount, isChecked);
        }
    }

    public void addAccounts(IAccount ... accounts) {
        if (Build.VERSION.SDK_INT < 11) {
            for (IAccount account : accounts) {
                this.mAccountListAdapter.add(account);
            }
        } else {
            this.mAccountListAdapter.addAll(accounts);
        }
        this.updateAccountHeader();
    }

    public void addAccount(IAccount account) {
        this.mAccountListAdapter.add(account);
        this.updateAccountHeader();
    }

    public void removeAccount(IAccount account) {
        this.mAccountListAdapter.remove(account);
        this.updateAccountHeader();
    }

    public void insertAccount(IAccount account, int position) {
        this.mAccountListAdapter.insert(account, position);
        this.updateAccountHeader();
    }

    public void clearAccounts() {
        this.mAccountListAdapter.clear();
        this.updateAccountHeader();
    }

    public List<IAccount> getAccounts() {
        return this.mAccountListAdapter.getAccounts();
    }

    public void setAccounts(List<IAccount> accounts) {
        this.mAccountListAdapter.setAccounts(accounts);
        this.updateAccountHeader();
    }

    public void checkAccount(IAccount account, boolean checked) {
        this.mAccountListAdapter.setChecked(this.mAccountListAdapter.indexOf(account), checked);
    }

    public ArrayList<IAccount> getCheckedAccounts() {
        return this.mAccountListAdapter.getChecked();
    }

    public void setAccountSelectedListener(OnAccountSelectedListener listener) {
        this.mListener = listener;
    }

    public boolean isShowingAccountList() {
        return this.mIsShowingAccountList;
    }

    public void showAccountList() {
        if (!this.mIsShowingAccountList) {
            this.mDropdownDrawable.startTransition(200);
            this.removeViewFromParent();
            this.mMenuAdapter = this.mNavigationMenuView.getAdapter();
            this.mNavigationMenuView.setAdapter((RecyclerView.Adapter)this.mAccountListAdapter);
        }
        this.mIsShowingAccountList = true;
    }

    public void hideAccountList() {
        if (this.mIsShowingAccountList) {
            this.mDropdownDrawable.reverseTransition(200);
            this.mNavigationMenuView.setAdapter(this.mMenuAdapter);
            this.mMenuAdapter = null;
            this.addViewToParent();
        }
        this.mIsShowingAccountList = false;
    }

    public void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0 && this.mNavigationMenuView == null) {
            this.mNavigationMenuView = (NavigationMenuView)this.getParent().getParent();
        }
    }

    private void switchPrimaryAccount(IAccount newPrimaryAccount) {
        this.mAccountListAdapter.move(newPrimaryAccount, 0);
        this.updateAccountHeader();
    }

    private void updateAccountHeader() {
        int accountCount = this.mAccountListAdapter.getAccountCount();
        if (accountCount == 0) {
            this.mPrimaryIconView.setVisibility(8);
            this.mNameView.setVisibility(8);
            this.mEmailView.setVisibility(8);
        } else {
            IAccount primaryAccount = this.mAccountListAdapter.get(0);
            AccountUtils.applyAccountIcon(primaryAccount, this.mPrimaryIconView);
            AccountUtils.applyAccountName(primaryAccount, this.mNameView);
            AccountUtils.applyAccountEmail(primaryAccount, this.mEmailView);
            this.mPrimaryIconView.setVisibility(0);
            this.mNameView.setVisibility(0);
            this.mEmailView.setVisibility(0);
        }
        if (accountCount <= 1) {
            this.mSecondaryFirstIconView.setVisibility(8);
        } else {
            AccountUtils.applyAccountIcon(this.mAccountListAdapter.get(1), this.mSecondaryFirstIconView);
            this.mSecondaryFirstIconView.setVisibility(0);
        }
        if (accountCount <= 2) {
            this.mSecondarySecondIconView.setVisibility(8);
        } else {
            AccountUtils.applyAccountIcon(this.mAccountListAdapter.get(2), this.mSecondarySecondIconView);
            this.mSecondarySecondIconView.setVisibility(0);
        }
    }

    private void removeViewFromParent() {
        this.getViewParent().removeView((View)this);
    }

    private void addViewToParent() {
        this.getViewParent().addView((View)this);
    }

    private ViewGroup getViewParent() {
        if (this.mParent == null) {
            this.mParent = (ViewGroup)this.getParent();
        }
        return this.mParent;
    }

    public static class OnAccountSelectedListenerAdapter
    implements OnAccountSelectedListener {
        @Override
        public boolean onAccountSelected(IAccount account) {
            return true;
        }

        @Override
        public void onAccountChecked(IAccount account, boolean isChecked) {
        }

        @Override
        public void onAccountAddSelected() {
        }

        @Override
        public void onAccountManageSelected() {
        }
    }

    public static interface OnAccountSelectedListener {
        public boolean onAccountSelected(IAccount var1);

        public void onAccountChecked(IAccount var1, boolean var2);

        public void onAccountAddSelected();

        public void onAccountManageSelected();
    }
}

