/*
 * Decompiled with CFR 0.152.
 */
package com.tr4android.support.extension.picker.date;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.widget.FrameLayout;
import com.tr4android.appcompat.extension.R;
import com.tr4android.support.extension.picker.date.AppCompatDatePickerDelegate;
import java.util.Calendar;
import java.util.Locale;

public class AppCompatDatePicker
extends FrameLayout {
    private static final String LOG_TAG = AppCompatDatePicker.class.getSimpleName();
    private final DatePickerDelegate mDelegate;

    public AppCompatDatePicker(Context context) {
        this(context, null);
    }

    public AppCompatDatePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AppCompatDatePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DatePickerDialog, defStyleAttr, 0);
        int firstDayOfWeek = a.getInt(R.styleable.DatePickerDialog_firstDayOfWeek, 0);
        a.recycle();
        this.mDelegate = this.createCalendarUIDelegate(context, attrs, defStyleAttr, 0);
        if (firstDayOfWeek != 0) {
            this.setFirstDayOfWeek(firstDayOfWeek);
        }
    }

    private DatePickerDelegate createCalendarUIDelegate(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        return new AppCompatDatePickerDelegate(this, context, attrs, defStyleAttr, defStyleRes);
    }

    public void init(int year, int monthOfYear, int dayOfMonth, OnDateChangedListener onDateChangedListener) {
        this.mDelegate.init(year, monthOfYear, dayOfMonth, onDateChangedListener);
    }

    public void updateDate(int year, int month, int dayOfMonth) {
        this.mDelegate.updateDate(year, month, dayOfMonth);
    }

    public int getYear() {
        return this.mDelegate.getYear();
    }

    public int getMonth() {
        return this.mDelegate.getMonth();
    }

    public int getDayOfMonth() {
        return this.mDelegate.getDayOfMonth();
    }

    public long getMinDate() {
        return this.mDelegate.getMinDate().getTimeInMillis();
    }

    public void setMinDate(long minDate) {
        this.mDelegate.setMinDate(minDate);
    }

    public long getMaxDate() {
        return this.mDelegate.getMaxDate().getTimeInMillis();
    }

    public void setMaxDate(long maxDate) {
        this.mDelegate.setMaxDate(maxDate);
    }

    public void setValidationCallback(@Nullable ValidationCallback callback) {
        this.mDelegate.setValidationCallback(callback);
    }

    public void setEnabled(boolean enabled) {
        if (this.mDelegate.isEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.mDelegate.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.mDelegate.isEnabled();
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        return this.mDelegate.dispatchPopulateAccessibilityEvent(event);
    }

    public void onPopulateAccessibilityEvent(AccessibilityEvent event) {
        super.onPopulateAccessibilityEvent(event);
        this.mDelegate.onPopulateAccessibilityEvent(event);
    }

    public CharSequence getAccessibilityClassName() {
        return AppCompatDatePicker.class.getName();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mDelegate.onConfigurationChanged(newConfig);
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek < 1 || firstDayOfWeek > 7) {
            throw new IllegalArgumentException("firstDayOfWeek must be between 1 and 7");
        }
        this.mDelegate.setFirstDayOfWeek(firstDayOfWeek);
    }

    public int getFirstDayOfWeek() {
        return this.mDelegate.getFirstDayOfWeek();
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return this.mDelegate.onSaveInstanceState(superState);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        View.BaseSavedState ss = (View.BaseSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mDelegate.onRestoreInstanceState((Parcelable)ss);
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mYear;
        private final int mMonth;
        private final int mDay;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int year, int month, int day) {
            super(superState);
            this.mYear = year;
            this.mMonth = month;
            this.mDay = day;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mYear = in.readInt();
            this.mMonth = in.readInt();
            this.mDay = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mYear);
            dest.writeInt(this.mMonth);
            dest.writeInt(this.mDay);
        }
    }

    public static interface ValidationCallback {
        public void onValidationChanged(boolean var1);
    }

    static abstract class AbstractDatePickerDelegate
    implements DatePickerDelegate {
        protected AppCompatDatePicker mDelegator;
        protected Context mContext;
        protected Locale mCurrentLocale;
        protected OnDateChangedListener mOnDateChangedListener;
        protected ValidationCallback mValidationCallback;

        public AbstractDatePickerDelegate(AppCompatDatePicker delegator, Context context) {
            this.mDelegator = delegator;
            this.mContext = context;
            this.setCurrentLocale(Locale.getDefault());
        }

        protected void setCurrentLocale(Locale locale) {
            if (!locale.equals(this.mCurrentLocale)) {
                this.mCurrentLocale = locale;
                this.onLocaleChanged(locale);
            }
        }

        @Override
        public void setValidationCallback(ValidationCallback callback) {
            this.mValidationCallback = callback;
        }

        protected void onValidationChanged(boolean valid) {
            if (this.mValidationCallback != null) {
                this.mValidationCallback.onValidationChanged(valid);
            }
        }

        protected void onLocaleChanged(Locale locale) {
        }
    }

    static interface DatePickerDelegate {
        public void init(int var1, int var2, int var3, OnDateChangedListener var4);

        public void updateDate(int var1, int var2, int var3);

        public int getYear();

        public int getMonth();

        public int getDayOfMonth();

        public void setFirstDayOfWeek(int var1);

        public int getFirstDayOfWeek();

        public void setMinDate(long var1);

        public Calendar getMinDate();

        public void setMaxDate(long var1);

        public Calendar getMaxDate();

        public void setEnabled(boolean var1);

        public boolean isEnabled();

        public void setValidationCallback(ValidationCallback var1);

        public void onConfigurationChanged(Configuration var1);

        public Parcelable onSaveInstanceState(Parcelable var1);

        public void onRestoreInstanceState(Parcelable var1);

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        public void onPopulateAccessibilityEvent(AccessibilityEvent var1);
    }

    public static interface OnDateChangedListener {
        public void onDateChanged(AppCompatDatePicker var1, int var2, int var3, int var4);
    }
}

