/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.parselisteners;

import io.digitalstate.camunda.prometheus.PrometheusProcessEnginePlugin;
import io.digitalstate.camunda.prometheus.config.yaml.DurationTrackingConfig;
import io.digitalstate.camunda.prometheus.executionlisteners.ProcessDurationExecutionListener;
import io.digitalstate.camunda.prometheus.parselisteners.ParsingHelpers;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.DelegateListener;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;

class ProcessDurationHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDurationHelpers.class);
    private static Map<String, DurationTrackingConfig> yamlFile = PrometheusProcessEnginePlugin.getYamlConfig().getActivityDurationTrackingConfigs();

    ProcessDurationHelpers() {
    }

    static boolean hasProcessDurationTracking(ProcessDefinitionEntity processDefinition, String containsValue) {
        Object documentationProperty = processDefinition.getProcessDefinition().getProperty("documentation");
        return documentationProperty != null && documentationProperty.toString().contains(containsValue);
    }

    static void generateProcessDurationListener(ProcessDefinitionEntity processDefinitionEntity, Element element, Map trackArguments) {
        String metricName = trackArguments.get("metric").toString();
        if (yamlFile.containsKey(metricName)) {
            DurationTrackingConfig config = yamlFile.get(metricName);
            config.setMetricName(metricName);
            if (trackArguments.containsKey("appendPdId")) {
                config.setAppendProcessDefinitionIdToMetricName(Boolean.parseBoolean(trackArguments.get("appendPdId").toString()));
            }
            ProcessDurationExecutionListener listener = new ProcessDurationExecutionListener(config);
            processDefinitionEntity.addListener("end", (DelegateListener)listener, 0);
            LOGGER.debug("Process Duration Tracker Listener has been added to {}", (Object)processDefinitionEntity.getId());
        } else {
            LOGGER.error("Could not parse Process: metric name ({}) in {} Process Element Document Field, could not be found in YAML configuration", (Object)metricName, (Object)processDefinitionEntity.getKey());
        }
    }

    static void processForProcessDurationTracking(Element element, ProcessDefinitionEntity processDefinition) {
        MultiValueMap<String, String> properties = ParsingHelpers.getCamundaExtensionPropertiesThatStartWith(element, "prometheus.");
        if (ParsingHelpers.hasTrack(properties).booleanValue()) {
            ((List)properties.get((Object)"prometheus.track")).forEach(item -> {
                Map property = ParsingHelpers.evalProperty(item);
                if (property.containsKey("type") && ((String)property.get("type")).equals("process-duration")) {
                    property.putIfAbsent("metric", "process_instance_duration");
                    ProcessDurationHelpers.generateProcessDurationListener(processDefinition, element, property);
                    LOGGER.debug("Process Duration Tracking has been added to {}, from BPMN Configuration", (Object)processDefinition.getKey());
                } else {
                    LOGGER.debug("Process Duration Tracking config is not found for {}", (Object)processDefinition.getKey());
                }
            });
        }
    }
}

