/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.parselisteners;

import io.digitalstate.camunda.prometheus.PrometheusProcessEnginePlugin;
import io.digitalstate.camunda.prometheus.config.yaml.DurationTrackingConfig;
import io.digitalstate.camunda.prometheus.executionlisteners.ActivityDurationExecutionListener;
import io.digitalstate.camunda.prometheus.parselisteners.ParsingHelpers;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.delegate.DelegateListener;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.MultiValueMap;

class ActivityDurationHelpers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActivityDurationHelpers.class);
    private static Map<String, DurationTrackingConfig> yamlFile = PrometheusProcessEnginePlugin.getYamlConfig().getActivityDurationTrackingConfigs();

    ActivityDurationHelpers() {
    }

    static boolean hasProcessWideActivityDurationTracking(ProcessDefinitionEntity processDefinition) {
        Object documentationProperty = processDefinition.getProcessDefinition().getProperty("documentation");
        return documentationProperty != null && documentationProperty.toString().contains("prometheus.track:{type:'activity-duration', metric:'activity_instance_duration'}");
    }

    static void generateActivityDurationListener(ActivityImpl activity, Element element, Map trackArguments) {
        String metricName = trackArguments.get("metric").toString();
        if (yamlFile.containsKey(metricName)) {
            DurationTrackingConfig config = yamlFile.get(metricName);
            config.setMetricName(metricName);
            if (trackArguments.containsKey("appendPdId")) {
                config.setAppendProcessDefinitionIdToMetricName(Boolean.parseBoolean(trackArguments.get("appendPdId").toString()));
            }
            ActivityDurationExecutionListener listener = new ActivityDurationExecutionListener(config);
            activity.addListener("end", (DelegateListener)listener, 0);
            LOGGER.debug("Activity Duration Tracker Listener has been added to {}", (Object)activity.getActivityId());
        } else {
            LOGGER.error("Could not parse Activity: metric name({}) in {} could not be found in YAML configuration", (Object)metricName, (Object)activity.getActivityId());
        }
    }

    static void processElementForActivityDurationTracking(Element element, ActivityImpl activity) {
        MultiValueMap<String, String> properties = ParsingHelpers.getCamundaExtensionPropertiesThatStartWith(element, "prometheus.");
        boolean processWideTracking = ActivityDurationHelpers.hasProcessWideActivityDurationTracking((ProcessDefinitionEntity)activity.getProcessDefinition());
        if (processWideTracking) {
            Map processWideConfig = ParsingHelpers.evalProperty("{type:'activity-duration', metric:'activity_instance_duration'}");
            ActivityDurationHelpers.generateActivityDurationListener(activity, element, processWideConfig);
            LOGGER.debug("Activity Duration Tracking has been added to {}, from BPMN Wide Tracking Configuration", (Object)activity.getActivityId());
        }
        if (ParsingHelpers.hasTrack(properties).booleanValue()) {
            ((List)properties.get((Object)"prometheus.track")).forEach(item -> {
                Map property = ParsingHelpers.evalProperty(item);
                if (property.containsKey("type") && property.get("type").equals("activity-duration") && property.containsKey("metric")) {
                    ActivityDurationHelpers.generateActivityDurationListener(activity, element, property);
                }
            });
            LOGGER.debug("Activity Duration Tracking has been added to {}, from Activity Definition specific configuration", (Object)activity.getActivityId());
        }
    }
}

