/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.digitalstate.camunda.prometheus.config.yaml.CustomMetricsConfig;
import io.digitalstate.camunda.prometheus.config.yaml.DurationTrackingConfig;
import io.digitalstate.camunda.prometheus.config.yaml.SystemMetricsConfig;
import io.digitalstate.camunda.prometheus.config.yaml.YamlFile;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YamlConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlConfig.class);
    private YamlFile yamlConfig = new YamlFile();
    private List<SystemMetricsConfig> systemMetricsConfigs = new ArrayList<SystemMetricsConfig>();
    private List<CustomMetricsConfig> customMetricsConfigs = new ArrayList<CustomMetricsConfig>();
    private Map<String, DurationTrackingConfig> activityDurationTrackingConfigs = new HashMap<String, DurationTrackingConfig>();

    public YamlConfig(String filePath) {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            Path file = Paths.get(filePath, new String[0]);
            this.yamlConfig = (YamlFile)mapper.readValue(file.toFile(), YamlFile.class);
            if (this.yamlConfig != null && !this.yamlConfig.getSystem().isEmpty()) {
                this.systemMetricsConfigs = this.yamlConfig.getSystem();
            } else {
                LOGGER.warn("No Prometheus Camunda System Metrics were not found.");
            }
            if (this.yamlConfig != null && !this.yamlConfig.getCustom().isEmpty()) {
                this.customMetricsConfigs = this.yamlConfig.getCustom();
            } else {
                LOGGER.info("No Custom Prometheus Metrics Collectors were found.");
            }
            if (this.yamlConfig != null && !this.yamlConfig.getDurationTracking().isEmpty()) {
                this.activityDurationTrackingConfigs = this.yamlConfig.getDurationTracking();
            } else {
                LOGGER.info("No Activity Duration Tracking Configs for Prometheus Metrics were found.");
            }
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            LOGGER.error("Unable to parse YAML, likely due to bad YAML format.");
            e.printStackTrace();
        }
    }

    public List<CustomMetricsConfig> getCustomMetricsConfigs() {
        return this.customMetricsConfigs;
    }

    public List<SystemMetricsConfig> getSystemMetricsConfigs() {
        return this.systemMetricsConfigs;
    }

    public Map<String, DurationTrackingConfig> getActivityDurationTrackingConfigs() {
        return this.activityDurationTrackingConfigs;
    }

    public YamlFile getYamlConfig() {
        return this.yamlConfig;
    }
}

