/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.collectors.custom;

import io.digitalstate.camunda.prometheus.config.yaml.CustomMetricsConfig;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.camunda.bpm.engine.ProcessEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class CamundaCustomMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaCustomMetrics.class);
    private static final Logger ScriptLOGGER = LoggerFactory.getLogger((String)"CamundaCustomMetrics-ScriptLOGGER");
    private static ScriptEngineManager engineManager = new ScriptEngineManager();
    private static ScriptEngine engine = engineManager.getEngineByName("Groovy");

    public CamundaCustomMetrics(List<CustomMetricsConfig> customMetricsConfigs, ProcessEngine processEngine) {
        LOGGER.info("Starting instance of Prometheus Camunda Custom Metrics");
        customMetricsConfigs.forEach(config -> this.processCustomMetricConfig((CustomMetricsConfig)config, processEngine));
    }

    private void processCustomMetricConfig(CustomMetricsConfig config, ProcessEngine processEngine) {
        if (config.getEnable().booleanValue()) {
            final Bindings bindings = engine.createBindings();
            bindings.put("config", (Object)config);
            bindings.put("processEngine", (Object)processEngine);
            bindings.put("LOGGER", (Object)ScriptLOGGER);
            final Resource scriptFile = config.getCollector();
            try {
                LOGGER.debug("Attempting to Compile Prometheus Custom Metric groovy script: " + scriptFile.toString());
                final CompiledScript compiledScript = ((Compilable)((Object)engine)).compile(new InputStreamReader(scriptFile.getInputStream()));
                String timerName = "Custom Timer: " + config.getCollector().getDescription();
                new Timer(timerName, true).schedule(new TimerTask(){

                    @Override
                    public void run() {
                        try {
                            LOGGER.debug("Executing Custom Metric: " + scriptFile.getDescription());
                            compiledScript.eval(bindings);
                        }
                        catch (ScriptException e) {
                            LOGGER.error("Prometheus Custom Metric groovy script threw exception!" + scriptFile.toString(), (Throwable)e);
                        }
                    }
                }, config.getStartDelay(), config.getFrequency());
            }
            catch (FileNotFoundException e) {
                LOGGER.error("Cannot find Groovy Script File." + scriptFile.getDescription(), (Throwable)e);
            }
            catch (ScriptException e) {
                LOGGER.error("Prometheus Custom Metric groovy script cannot compile." + scriptFile.getDescription(), (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error("Could not compile script, unable to get InputStream: " + scriptFile.getDescription(), (Throwable)e);
            }
        }
    }
}

