/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.collectors.camunda;

import io.digitalstate.camunda.prometheus.collectors.SimpleGaugeMetric;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.management.MetricsQuery;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BpmnExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnExecution.class);

    public BpmnExecution(final ProcessEngine processEngine, final DateTime startDate, final DateTime endDate, long startDelayMills, long frequencyMills) {
        String timerName = this.getClass().getName() + " timer";
        new Timer(timerName, true).schedule(new TimerTask(){

            @Override
            public void run() {
                BpmnExecution.collectAll(processEngine, startDate, endDate);
            }
        }, startDelayMills, frequencyMills);
        LOGGER.info("Created Prometheus Metrics Collection Timer for: " + this.getClass().getName());
    }

    public static void collectActivityInstancesStarted(MetricsQuery metricsQuery, String engineName, DateTime startDate, DateTime endDate) {
        SimpleGaugeMetric counter = new SimpleGaugeMetric("metric_activity_instance_start", "The number of activity instances started. This is also known as flow node instances (FNI).", Arrays.asList("engine_name"));
        long sum = metricsQuery.name("activity-instance-start").startDate(startDate.toDate()).endDate(endDate.toDate()).sum();
        LOGGER.debug("Collecting Metric Count for Instances Started: " + sum);
        counter.setValue(sum, Arrays.asList(engineName));
    }

    public static void collectActivityInstancesEnded(MetricsQuery metricsQuery, String engineName, DateTime startDate, DateTime endDate) {
        SimpleGaugeMetric counter = new SimpleGaugeMetric("metric_activity_instance_end", "The number of activity instances ended.", Arrays.asList("engine_name"));
        long sum = metricsQuery.name("activity-instance-end").startDate(startDate.toDate()).endDate(endDate.toDate()).sum();
        LOGGER.debug("Collecting Metric Count for Instances Ended: " + sum);
        counter.setValue(sum, Arrays.asList(engineName));
    }

    public static void collectAll(ProcessEngine processEngine, DateTime startDate, DateTime endDate) {
        MetricsQuery metricsQuery = processEngine.getManagementService().createMetricsQuery();
        String engineName = processEngine.getName();
        BpmnExecution.collectActivityInstancesStarted(metricsQuery, engineName, startDate, endDate);
        BpmnExecution.collectActivityInstancesEnded(metricsQuery, engineName, startDate, endDate);
    }
}

