/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.grafana.annotations;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.digitalstate.camunda.grafana.annotations.GrafanaAnnotation;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrafanaAnnotationReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrafanaAnnotationReporter.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private URI grafanaUri;
    private String authToken;

    public GrafanaAnnotationReporter() {
        this.setGrafanaUri(URI.create("http://localhost:3000"));
    }

    public GrafanaAnnotationReporter(URI grafanaUri) {
        this.setGrafanaUri(grafanaUri);
    }

    public GrafanaAnnotationReporter(URI grafanaUri, String authToken) {
        this.setAuthToken(authToken);
        this.setGrafanaUri(grafanaUri);
    }

    public HttpResponse createAnnotation(GrafanaAnnotation ga) throws IOException, URISyntaxException {
        URI createAnnotationUri = new URI(this.getGrafanaUri().toString() + "/api/annotations");
        Request request = Request.Post((URI)createAnnotationUri).addHeader("Accept", ContentType.APPLICATION_JSON.toString()).addHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        if (this.getAuthToken() != null) {
            request.addHeader("Authorization", "Bearer " + this.getAuthToken());
        }
        String requestBody = this.objectMapper.writeValueAsString((Object)ga);
        request.bodyString(requestBody, ContentType.APPLICATION_JSON);
        LOGGER.debug("Grafana Annotation Request JSON Body: {}", (Object)requestBody);
        LOGGER.debug("GRAFANA HTTP REQUEST: {}", (Object)request.toString());
        return request.execute().returnResponse();
    }

    private void setGrafanaUri(URI grafanaUri) {
        this.grafanaUri = grafanaUri;
    }

    private URI getGrafanaUri() {
        return this.grafanaUri;
    }

    private void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    private String getAuthToken() {
        return this.authToken;
    }
}

