/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.parselisteners;

import io.digitalstate.camunda.prometheus.parselisteners.ActivityDurationHelpers;
import io.digitalstate.camunda.prometheus.parselisteners.ProcessDurationHelpers;
import org.camunda.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnDurationTrackingParseListener
extends AbstractBpmnParseListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnDurationTrackingParseListener.class);

    public void parseProcess(Element element, ProcessDefinitionEntity processDefinition) {
        if (ActivityDurationHelpers.hasProcessWideActivityDurationTracking(processDefinition)) {
            LOGGER.info("Process Wide Activity Duration Tracking is active for {}", (Object)processDefinition.getKey());
        }
        ProcessDurationHelpers.processForProcessDurationTracking(element, processDefinition);
    }

    public void parseStartEvent(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseExclusiveGateway(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseInclusiveGateway(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseParallelGateway(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseScriptTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseServiceTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseBusinessRuleTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseManualTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseUserTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseEndEvent(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseBoundaryTimerEventDefinition(Element element, boolean interrupting, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseBoundaryErrorEventDefinition(Element element, boolean interrupting, ActivityImpl activity, ActivityImpl nestedErrorEventActivity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseSubProcess(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseCallActivity(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseSendTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseIntermediateTimerEventDefinition(Element element, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseReceiveTask(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseIntermediateSignalCatchEventDefinition(Element element, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseBoundarySignalEventDefinition(Element element, boolean interrupting, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseEventBasedGateway(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseTransaction(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseCompensateEventDefinition(Element element, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseIntermediateThrowEvent(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseIntermediateCatchEvent(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseBoundaryEvent(Element element, ScopeImpl scope, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseIntermediateMessageCatchEventDefinition(Element element, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseBoundaryMessageEventDefinition(Element element, boolean interrupting, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseBoundaryEscalationEventDefinition(Element element, boolean interrupting, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseBoundaryConditionalEventDefinition(Element element, boolean interrupting, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseIntermediateConditionalEventDefinition(Element element, ActivityImpl activity) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }

    public void parseConditionalStartEventForEventSubprocess(Element element, ActivityImpl activity, boolean interrupting) {
        ActivityDurationHelpers.processElementForActivityDurationTracking(element, activity);
    }
}

