/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.config.yaml;

import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMetricsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemMetricsConfig.class);
    private Class<?> collector;
    private Boolean enable;
    private DateTime startDate;
    private DateTime endDate;
    private long startDelay;
    private long frequency;

    public void setCollector(String className) {
        try {
            this.collector = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Cannot find class: " + className, (Throwable)e);
        }
    }

    public Class<?> getCollector() {
        return this.collector;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate.equals("now") ? DateTimeUtil.now() : DateTimeUtil.parseDateTime((String)startDate);
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate.equals("now") ? DateTimeUtil.now().plusYears(100) : DateTimeUtil.parseDateTime((String)endDate);
    }

    public DateTime getEndDate() {
        return this.endDate;
    }

    public void setStartDelay(long startDelay) {
        this.startDelay = startDelay;
    }

    public long getStartDelay() {
        return this.startDelay;
    }

    public void setFrequency(long frequency) {
        this.frequency = frequency;
    }

    public long getFrequency() {
        return this.frequency;
    }
}

