/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.collectors.camunda;

import io.digitalstate.camunda.prometheus.collectors.SimpleGaugeMetric;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.management.MetricsQuery;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DmnExecution {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnExecution.class);

    public DmnExecution(final ProcessEngine processEngine, final DateTime startDate, final DateTime endDate, long startDelayMills, long frequencyMills) {
        String timerName = this.getClass().getName() + " timer";
        new Timer(timerName, true).schedule(new TimerTask(){

            @Override
            public void run() {
                DmnExecution.collectAll(processEngine, startDate, endDate);
            }
        }, startDelayMills, frequencyMills);
        LOGGER.info("Created Prometheus Metrics Collection Timer for: " + this.getClass().getName());
    }

    public static void collectExecutedDecisionElements(MetricsQuery metricsQuery, String engineName, DateTime startDate, DateTime endDate) {
        SimpleGaugeMetric counter = new SimpleGaugeMetric("metric_executed_decision_elements", "The number of decision elements executed during evaluation of DMN decision tables. For one table, this is calculated as the number of clauses multiplied by the number of rules.", Arrays.asList("engine_name"));
        long sum = metricsQuery.name("executed-decision-elements").startDate(startDate.toDate()).endDate(endDate.toDate()).sum();
        LOGGER.debug("Collecting Metric Count for Executed Decision Elements: " + sum);
        counter.setValue(sum, Arrays.asList(engineName));
    }

    public static void collectAll(ProcessEngine processEngine, DateTime startDate, DateTime endDate) {
        MetricsQuery metricsQuery = processEngine.getManagementService().createMetricsQuery();
        String engineName = processEngine.getName();
        DmnExecution.collectExecutedDecisionElements(metricsQuery, engineName, startDate, endDate);
    }
}

