/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.collectors.camunda;

import io.digitalstate.camunda.prometheus.config.yaml.SystemMetricsConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamundaMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaMetrics.class);

    public CamundaMetrics(List<SystemMetricsConfig> systemMetricsConfigs, ProcessEngine processEngine) {
        LOGGER.info("Starting instance of Prometheus Camunda Metrics");
        systemMetricsConfigs.forEach(config -> this.processSystemMetricConfig((SystemMetricsConfig)config, processEngine));
    }

    private void processSystemMetricConfig(SystemMetricsConfig config, ProcessEngine processEngine) {
        if (config.getEnable().booleanValue()) {
            try {
                Constructor<?> collectorConstructor = config.getCollector().getConstructor(ProcessEngine.class, DateTime.class, DateTime.class, Long.TYPE, Long.TYPE);
                collectorConstructor.newInstance(processEngine, config.getStartDate(), config.getEndDate(), config.getStartDelay(), config.getFrequency());
            }
            catch (NoSuchMethodException e) {
                LOGGER.error("Cant Find Method", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Illegal Access", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.error("Could not Instantiate", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Invocation Target Exception", (Throwable)e);
            }
        }
    }
}

