/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.collectors;

import io.prometheus.client.Summary;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSummaryMetric {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSummaryMetric.class);
    private static ConcurrentMap<String, Summary> summaries = new ConcurrentHashMap<String, Summary>();
    private final String summaryName;
    private Summary.Timer requestTimer;

    public SimpleSummaryMetric(String name, String help, List<String> labelNames) {
        summaries.computeIfAbsent(name, k -> {
            Summary.Builder summaryBuilder = (Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().namespace("camunda")).name(name)).help(help);
            if (labelNames != null) {
                summaryBuilder.labelNames(labelNames.toArray(new String[0]));
            }
            Summary summary = (Summary)summaryBuilder.register();
            LOGGER.info("Prometheus SimpleSummaryMetric has been created: " + name);
            return summary;
        });
        this.summaryName = name;
    }

    public void startTimer(List<String> labels) {
        Summary summary = (Summary)summaries.get(this.summaryName);
        if (labels != null) {
            summary.labels(labels.toArray(new String[0]));
        }
        this.requestTimer = summary.startTimer();
    }

    public void startTimer() {
        Summary summary = (Summary)summaries.get(this.summaryName);
        this.requestTimer = summary.startTimer();
    }

    public void observeDuration() {
        this.requestTimer.observeDuration();
    }

    public void observeValue(Double observedValue, List<String> labels) {
        Summary summary = (Summary)summaries.get(this.summaryName);
        ((Summary.Child)summary.labels(labels.toArray(new String[0]))).observe(observedValue.doubleValue());
    }

    public void observeValue(Double observedValue) {
        Summary summary = (Summary)summaries.get(this.summaryName);
        summary.observe(observedValue.doubleValue());
    }

    public SimpleSummaryMetric(String name) {
        this(name, "A basic summary", null);
    }

    public String getSummaryName() {
        return this.summaryName;
    }

    public Summary.Child.Value getValue() {
        return ((Summary)summaries.get(this.summaryName)).get();
    }

    public Summary.Child.Value getValue(List<String> labels) {
        return ((Summary.Child)((Summary)summaries.get(this.summaryName)).labels(labels.toArray(new String[0]))).get();
    }
}

