/*
 * Decompiled with CFR 0.152.
 */
package io.digitalstate.camunda.prometheus.collectors;

import io.prometheus.client.Histogram;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHistogramMetric {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleHistogramMetric.class);
    private static ConcurrentMap<String, Histogram> histograms = new ConcurrentHashMap<String, Histogram>();
    private final String histogramName;
    private Histogram.Timer requestTimer;

    public SimpleHistogramMetric(String name, String help, List<Double> buckets, List<String> labelNames) {
        histograms.computeIfAbsent(name, k -> {
            Histogram.Builder summaryBuilder = (Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("camunda")).name(name)).help(help);
            if (buckets != null) {
                summaryBuilder.buckets(buckets.stream().mapToDouble(Double::doubleValue).toArray());
            }
            if (labelNames != null) {
                summaryBuilder.labelNames(labelNames.toArray(new String[0]));
            }
            Histogram summary = (Histogram)summaryBuilder.register();
            LOGGER.info("Prometheus SimpleHistogramMetric has been created: " + name);
            return summary;
        });
        this.histogramName = name;
    }

    public SimpleHistogramMetric(String name) {
        this(name, "A basic histogram", null, null);
    }

    public void startTimer(List<String> labels) {
        this.requestTimer = ((Histogram.Child)((Histogram)histograms.get(this.histogramName)).labels(labels.toArray(new String[0]))).startTimer();
    }

    public void startTimer() {
        Histogram histogram = (Histogram)histograms.get(this.histogramName);
        this.requestTimer = histogram.startTimer();
    }

    public void observeDuration() {
        this.requestTimer.observeDuration();
    }

    public void observeValue(Number observedValue, List<String> labels) {
        Histogram histogram = (Histogram)histograms.get(this.histogramName);
        ((Histogram.Child)histogram.labels(labels.toArray(new String[0]))).observe(observedValue.doubleValue());
    }

    public void observeValue(Number observedValue) {
        Histogram histogram = (Histogram)histograms.get(this.histogramName);
        histogram.observe(observedValue.doubleValue());
    }

    public String getHistogramName() {
        return this.histogramName;
    }
}

