/*
 * Decompiled with CFR 0.152.
 */
package com.github.statusbar;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.v4.graphics.ColorUtils;
import android.support.v4.widget.DrawerLayout;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import com.github.statusbar.R;
import java.lang.reflect.Method;

public class StatusBarUtils {
    private static boolean isEMUI3 = false;

    private static boolean isNull(Object object) {
        return object == null;
    }

    public static void setStatusColor(Activity activity) {
        StatusBarUtils.setStatusColor(activity, true);
    }

    public static void setStatusColor(Activity activity, boolean isIntoStatusBar) {
        StatusBarUtils.setStatusColor(activity, 0, isIntoStatusBar);
    }

    public static void setStatusColor(Activity activity, @ColorInt int color) {
        StatusBarUtils.setStatusColor(activity, color, 0.0f, true);
    }

    public static void setStatusColor(Activity activity, @ColorInt int color, boolean isIntoStatusBar) {
        StatusBarUtils.setStatusColor(activity, color, 0.0f, isIntoStatusBar);
    }

    public static void setStatusColor(Activity activity, @ColorInt int color, @FloatRange(from=0.0, to=1.0) float ratio) {
        StatusBarUtils.setStatusColor(activity, color, -16777216, ratio, true);
    }

    public static void setStatusColor(Activity activity, @ColorInt int color, @FloatRange(from=0.0, to=1.0) float ratio, boolean isIntoStatusBar) {
        StatusBarUtils.setStatusColor(activity, color, -16777216, ratio, isIntoStatusBar);
    }

    public static void setStatusColor(Activity activity, @ColorInt int color, @ColorInt int colorEnd, @FloatRange(from=0.0, to=1.0) float ratio) {
        StatusBarUtils.setStatusColor(activity, color, colorEnd, ratio, true);
    }

    public static void setStatusColor(Activity activity, @ColorInt int color, @ColorInt int colorEnd, @FloatRange(from=0.0, to=1.0) float ratio, boolean isIntoStatusBar) {
        if (StatusBarUtils.isNull(activity)) {
            return;
        }
        final ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        if (decorView == null) {
            return;
        }
        int statusBarColor = ColorUtils.blendARGB((int)color, (int)colorEnd, (float)ratio);
        Window window = activity.getWindow();
        if (Build.VERSION.SDK_INT >= 21 && !StatusBarUtils.isEmotionUI3()) {
            int systemUiVisibility = decorView.getSystemUiVisibility();
            systemUiVisibility = isIntoStatusBar ? (systemUiVisibility |= 0x400) : (systemUiVisibility &= 0xFFFFFBFF);
            final int finalSystemUiVisibility = systemUiVisibility;
            decorView.post(new Runnable(){

                @Override
                public void run() {
                    decorView.setSystemUiVisibility(finalSystemUiVisibility);
                }
            });
            window.setStatusBarColor(statusBarColor);
        } else if (Build.VERSION.SDK_INT >= 19) {
            window.addFlags(0x4000000);
            View statusBarView = decorView.findViewById(R.id.status_bar_view_id);
            if (statusBarView == null) {
                statusBarView = StatusBarUtils.createStatusBarView(activity, statusBarColor);
                decorView.addView(statusBarView);
            } else {
                statusBarView.setBackgroundColor(statusBarColor);
            }
            ViewGroup contentView = (ViewGroup)decorView.findViewById(0x1020002);
            if (contentView == null) {
                return;
            }
            contentView.setPadding(0, isIntoStatusBar ? 0 : StatusBarUtils.getStatusBarHeight((Context)activity), 0, 0);
        }
    }

    @Deprecated
    public static void setStatusColorForDrawerLayout(Activity activity, DrawerLayout drawerLayout, @ColorInt int color) {
        StatusBarUtils.setStatusColorForDrawerLayout(activity, drawerLayout, color, -16777216, 0.0f);
    }

    @Deprecated
    public static void setStatusColorForDrawerLayout(Activity activity, DrawerLayout drawerLayout, @ColorInt int color, @FloatRange(from=0.0, to=1.0) float ratio) {
        StatusBarUtils.setStatusColorForDrawerLayout(activity, drawerLayout, color, -16777216, ratio);
    }

    @Deprecated
    public static void setStatusColorForDrawerLayout(Activity activity, DrawerLayout drawerLayout, @ColorInt int color, @ColorInt int colorEnd, @FloatRange(from=0.0, to=1.0) float ratio) {
        if (StatusBarUtils.isNull(activity)) {
            return;
        }
        Window window = activity.getWindow();
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        if (decorView == null) {
            return;
        }
        int statusBarColor = ColorUtils.blendARGB((int)color, (int)colorEnd, (float)ratio);
        if (Build.VERSION.SDK_INT >= 21 && !StatusBarUtils.isEmotionUI3()) {
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(0);
            decorView.setSystemUiVisibility(1280);
        } else if (Build.VERSION.SDK_INT >= 19) {
            window.addFlags(0x4000000);
        }
        int statusBarHeight = StatusBarUtils.getStatusBarHeight((Context)activity);
        for (int i = 0; i < drawerLayout.getChildCount(); ++i) {
            if (i == 0) {
                View statusBarView;
                View childAt = drawerLayout.getChildAt(0);
                drawerLayout.removeView(childAt);
                View parentView = drawerLayout.findViewById(R.id.status_bar_view_parent_id);
                LinearLayout linearLayout = null;
                if (parentView == null) {
                    linearLayout = new LinearLayout((Context)activity);
                    linearLayout.setId(R.id.status_bar_view_parent_id);
                    linearLayout.setOrientation(1);
                    linearLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
                    linearLayout.addView(childAt);
                    drawerLayout.addView((View)linearLayout, 0);
                }
                if ((statusBarView = drawerLayout.findViewById(R.id.status_bar_view_id)) == null) {
                    statusBarView = StatusBarUtils.createStatusBarView(activity, statusBarColor);
                    linearLayout.addView(statusBarView, 0);
                    continue;
                }
                statusBarView.setBackgroundColor(statusBarColor);
                continue;
            }
            View layoutChildAt = drawerLayout.getChildAt(i);
            layoutChildAt.setPadding(layoutChildAt.getPaddingLeft(), statusBarHeight + layoutChildAt.getPaddingTop(), layoutChildAt.getPaddingRight(), layoutChildAt.getPaddingBottom());
        }
    }

    private static View createStatusBarView(Activity activity, @ColorInt int statusBarColor) {
        View view = new View((Context)activity);
        view.setId(R.id.status_bar_view_id);
        view.setLayoutParams(new ViewGroup.LayoutParams(-1, StatusBarUtils.getStatusBarHeight((Context)activity)));
        view.setBackgroundColor(statusBarColor);
        return view;
    }

    public static int getStatusBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    public static boolean isEmotionUI3() {
        if (isEMUI3) {
            return isEMUI3;
        }
        String property = StatusBarUtils.getSystemProperty("ro.build.version.emui", "");
        if ("EmotionUI 3".equals(property) || property.contains("EmotionUI_3.1")) {
            isEMUI3 = true;
            return true;
        }
        return false;
    }

    private static String getSystemProperty(String key, String defaultValue) {
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method get = clz.getMethod("get", String.class, String.class);
            get.setAccessible(true);
            return (String)get.invoke(clz, key, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }
}

