/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.view.helper;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.LinearInterpolator;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import cc.shinichi.library.ImagePreview;
import cc.shinichi.library.R;
import cc.shinichi.library.view.helper.SubsamplingScaleImageViewDragClose;
import cc.shinichi.library.view.nine.ViewHelper;
import cc.shinichi.library.view.photoview.PhotoView;

public class FingerDragHelper
extends LinearLayout {
    private static final String TAG = FingerDragHelper.class.getSimpleName();
    private static final int MAX_EXIT_Y = 500;
    private static final long DURATION = 200L;
    private static final int MAX_TRANSLATE_Y = 500;
    private final int fadeIn = R.anim.fade_in_150;
    private final int fadeOut = R.anim.fade_out_150;
    private SubsamplingScaleImageViewDragClose imageView;
    private PhotoView imageGif;
    private float mDownY;
    private float mTranslationY;
    private float mLastTranslationY;
    private boolean isAnimate = false;
    private int mTouchslop;
    private onAlphaChangedListener mOnAlphaChangedListener;

    public FingerDragHelper(Context context) {
        this(context, null);
    }

    public FingerDragHelper(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FingerDragHelper(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initViews();
    }

    private void initViews() {
        this.mTouchslop = ViewConfiguration.getTouchSlop();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.imageView = (SubsamplingScaleImageViewDragClose)this.getChildAt(0);
        this.imageGif = (PhotoView)this.getChildAt(1);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        boolean isIntercept = false;
        int action = ev.getAction() & ev.getActionMasked();
        switch (action) {
            case 0: {
                this.mDownY = ev.getRawY();
            }
            case 2: {
                if (!ImagePreview.getInstance().isEnableDragClose()) break;
                if (this.imageGif != null && this.imageGif.getVisibility() == 0) {
                    isIntercept = this.imageGif.getScale() <= this.imageGif.getMinimumScale() + 0.001f && (this.imageGif.getMaxTouchCount() == 0 || this.imageGif.getMaxTouchCount() == 1) && Math.abs(ev.getRawY() - this.mDownY) > (float)(2 * this.mTouchslop);
                    break;
                }
                if (this.imageView == null || this.imageView.getVisibility() != 0) break;
                if (ImagePreview.getInstance().isEnableDragCloseIgnoreScale()) {
                    isIntercept = (this.imageView.getScale() <= this.imageView.getMinScale() + 0.001f || this.imageView.atYEdge) && (this.imageView.getMaxTouchCount() == 0 || this.imageView.getMaxTouchCount() == 1) && Math.abs(ev.getRawY() - this.mDownY) > (float)(2 * this.mTouchslop);
                    break;
                }
                isIntercept = this.imageView.getScale() <= this.imageView.getMinScale() + 0.001f && (this.imageView.getMaxTouchCount() == 0 || this.imageView.getMaxTouchCount() == 1) && Math.abs(ev.getRawY() - this.mDownY) > (float)(2 * this.mTouchslop) && this.imageView.atYEdge;
                break;
            }
        }
        return isIntercept;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction() & event.getActionMasked();
        switch (action) {
            case 0: {
                this.mDownY = event.getRawY();
            }
            case 2: {
                if (!ImagePreview.getInstance().isEnableDragClose()) break;
                if (this.imageGif != null && this.imageGif.getVisibility() == 0) {
                    this.onOneFingerPanActionMove(event);
                    break;
                }
                if (this.imageView == null || this.imageView.getVisibility() != 0) break;
                this.onOneFingerPanActionMove(event);
                break;
            }
            case 1: {
                this.onActionUp();
                break;
            }
        }
        return true;
    }

    private void onOneFingerPanActionMove(MotionEvent event) {
        float moveY = event.getRawY();
        this.mTranslationY = moveY - this.mDownY + this.mLastTranslationY;
        if (null != this.mOnAlphaChangedListener) {
            this.mOnAlphaChangedListener.onTranslationYChanged(event, this.mTranslationY);
        }
        ViewHelper.setScrollY((View)this, -((int)this.mTranslationY));
    }

    private void onActionUp() {
        boolean enableUpDragClose = ImagePreview.getInstance().isEnableUpDragClose();
        if (enableUpDragClose) {
            if (Math.abs(this.mTranslationY) > 500.0f) {
                this.exitWithTranslation(this.mTranslationY);
            } else {
                this.resetCallBackAnimation();
            }
        } else if (this.mTranslationY > 500.0f) {
            this.exitWithTranslation(this.mTranslationY);
        } else {
            this.resetCallBackAnimation();
        }
    }

    public void exitWithTranslation(float currentY) {
        if (currentY > 0.0f) {
            ValueAnimator animDown = ValueAnimator.ofFloat((float[])new float[]{this.mTranslationY, this.getHeight()});
            animDown.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float fraction = ((Float)animation.getAnimatedValue()).floatValue();
                    ViewHelper.setScrollY((View)FingerDragHelper.this, -((int)fraction));
                }
            });
            animDown.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    FingerDragHelper.this.reset();
                    Activity activity = (Activity)FingerDragHelper.this.getContext();
                    activity.finish();
                    activity.overridePendingTransition(FingerDragHelper.this.fadeIn, FingerDragHelper.this.fadeOut);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            animDown.setDuration(200L);
            animDown.setInterpolator((TimeInterpolator)new LinearInterpolator());
            animDown.start();
        } else {
            ValueAnimator animUp = ValueAnimator.ofFloat((float[])new float[]{this.mTranslationY, -this.getHeight()});
            animUp.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float fraction = ((Float)animation.getAnimatedValue()).floatValue();
                    ViewHelper.setScrollY((View)FingerDragHelper.this, -((int)fraction));
                }
            });
            animUp.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    FingerDragHelper.this.reset();
                    ((Activity)FingerDragHelper.this.getContext()).finish();
                    ((Activity)FingerDragHelper.this.getContext()).overridePendingTransition(FingerDragHelper.this.fadeIn, FingerDragHelper.this.fadeOut);
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            animUp.setDuration(200L);
            animUp.setInterpolator((TimeInterpolator)new LinearInterpolator());
            animUp.start();
        }
    }

    private void resetCallBackAnimation() {
        ValueAnimator animatorY = ValueAnimator.ofFloat((float[])new float[]{this.mTranslationY, 0.0f});
        animatorY.setDuration(200L);
        animatorY.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                if (FingerDragHelper.this.isAnimate) {
                    FingerDragHelper.this.mTranslationY = ((Float)valueAnimator.getAnimatedValue()).floatValue();
                    FingerDragHelper.this.mLastTranslationY = FingerDragHelper.this.mTranslationY;
                    ViewHelper.setScrollY((View)FingerDragHelper.this, -((int)FingerDragHelper.this.mTranslationY));
                }
            }
        });
        animatorY.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                FingerDragHelper.this.isAnimate = true;
            }

            public void onAnimationEnd(Animator animation) {
                if (FingerDragHelper.this.isAnimate) {
                    FingerDragHelper.this.mTranslationY = 0.0f;
                    FingerDragHelper.this.invalidate();
                    FingerDragHelper.this.reset();
                }
                FingerDragHelper.this.isAnimate = false;
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animatorY.start();
    }

    public void setOnAlphaChangeListener(onAlphaChangedListener alphaChangeListener) {
        this.mOnAlphaChangedListener = alphaChangeListener;
    }

    private void reset() {
        if (null != this.mOnAlphaChangedListener) {
            this.mOnAlphaChangedListener.onTranslationYChanged(null, this.mTranslationY);
        }
    }

    public static interface onAlphaChangedListener {
        public void onTranslationYChanged(MotionEvent var1, float var2);
    }
}

