/*
 * Decompiled with CFR 0.152.
 */
package cc.shinichi.library.glide;

import android.content.Context;
import androidx.appcompat.app.AppCompatActivity;
import cc.shinichi.library.glide.cache.DataCacheKey;
import cc.shinichi.library.glide.cache.SafeKeyGenerator;
import com.bumptech.glide.Glide;
import com.bumptech.glide.disklrucache.DiskLruCache;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.signature.EmptySignature;
import java.io.File;

public class ImageLoader {
    public static File getGlideCacheFile(Context context, String url) {
        try {
            DataCacheKey dataCacheKey = new DataCacheKey((Key)new GlideUrl(url), (Key)EmptySignature.obtain());
            SafeKeyGenerator safeKeyGenerator = new SafeKeyGenerator();
            String safeKey = safeKeyGenerator.getSafeKey(dataCacheKey);
            File file = new File(context.getCacheDir(), "image_manager_disk_cache");
            DiskLruCache diskLruCache = DiskLruCache.open((File)file, (int)1, (int)1, (long)0xFA00000L);
            DiskLruCache.Value value = diskLruCache.get(safeKey);
            if (value != null) {
                return value.getFile(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void clearMemory(AppCompatActivity activity) {
        Glide.get((Context)activity.getApplicationContext()).clearMemory();
    }

    public static void cleanDiskCache(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Glide.get((Context)context.getApplicationContext()).clearDiskCache();
            }
        }).start();
    }
}

