/*
 * Decompiled with CFR 0.152.
 */
package com.shashank.sony.fancywalkthroughlib;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.ColorRes;
import android.support.annotation.RequiresApi;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.shashank.sony.fancywalkthroughlib.FancyWalkthroughAdapter;
import com.shashank.sony.fancywalkthroughlib.FancyWalkthroughCard;
import com.shashank.sony.fancywalkthroughlib.R;
import com.shashank.sony.fancywalkthroughlib.utils.ShadowTransformer;
import com.shashank.sony.fancywalkthroughlib.views.CircleIndicatorView;
import java.util.List;

public abstract class FancyWalkthroughActivity
extends AppCompatActivity
implements View.OnClickListener,
ViewPager.OnPageChangeListener {
    private CircleIndicatorView circleIndicatorView;
    private ViewPager vpOnboarderPager;
    private FancyWalkthroughAdapter ahoyOnboarderAdapter;
    private TextView btnSkip;
    private ImageView ivNext;
    private ImageView ivPrev;
    private FrameLayout navigationControls;
    private FrameLayout buttonsLayout;
    private RelativeLayout parentLayout;
    private ImageView backgroundImage;
    private ShadowTransformer mCardShadowTransformer;
    private Typeface typeface;
    private List<Integer> colorList;
    private boolean solidBackground = false;
    private List<FancyWalkthroughCard> pages;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_ahoy);
        this.setStatusBackgroundColor();
        this.hideActionBar();
        this.parentLayout = (RelativeLayout)this.findViewById(R.id.parent_layout);
        this.circleIndicatorView = (CircleIndicatorView)this.findViewById(R.id.circle_indicator_view);
        this.btnSkip = (TextView)this.findViewById(R.id.btn_skip);
        this.buttonsLayout = (FrameLayout)this.findViewById(R.id.buttons_layout);
        this.navigationControls = (FrameLayout)this.findViewById(R.id.navigation_layout);
        this.ivNext = (ImageView)this.findViewById(R.id.ivNext);
        this.ivPrev = (ImageView)this.findViewById(R.id.ivPrev);
        this.backgroundImage = (ImageView)this.findViewById(R.id.background_image);
        this.vpOnboarderPager = (ViewPager)this.findViewById(R.id.vp_pager);
        this.vpOnboarderPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.btnSkip.setOnClickListener((View.OnClickListener)this);
        this.ivPrev.setOnClickListener((View.OnClickListener)this);
        this.ivNext.setOnClickListener((View.OnClickListener)this);
        this.hideFinish(false);
        this.fadeOut((View)this.ivPrev, false);
    }

    public void setOnboardPages(List<FancyWalkthroughCard> pages) {
        this.pages = pages;
        this.ahoyOnboarderAdapter = new FancyWalkthroughAdapter(pages, this.getSupportFragmentManager(), this.dpToPixels(0, (Context)this), this.typeface);
        this.mCardShadowTransformer = new ShadowTransformer(this.vpOnboarderPager, this.ahoyOnboarderAdapter);
        this.mCardShadowTransformer.enableScaling(true);
        this.vpOnboarderPager.setAdapter((PagerAdapter)this.ahoyOnboarderAdapter);
        this.vpOnboarderPager.setPageTransformer(false, (ViewPager.PageTransformer)this.mCardShadowTransformer);
        this.circleIndicatorView.setPageIndicators(pages.size());
    }

    public float dpToPixels(int dp, Context context) {
        return (float)dp * context.getResources().getDisplayMetrics().density;
    }

    private void setStatusBackgroundColor() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().getDecorView().setSystemUiVisibility(1280);
            this.getWindow().setStatusBarColor(ContextCompat.getColor((Context)this, (int)R.color.black_transparent));
        }
    }

    public void onClick(View v) {
        boolean isInLastPage;
        int i = v.getId();
        boolean isInFirstPage = this.vpOnboarderPager.getCurrentItem() == 0;
        boolean bl = isInLastPage = this.vpOnboarderPager.getCurrentItem() == this.ahoyOnboarderAdapter.getCount() - 1;
        if (i == R.id.btn_skip && isInLastPage) {
            this.onFinishButtonPressed();
        } else if (i == R.id.ivPrev && !isInFirstPage) {
            this.vpOnboarderPager.setCurrentItem(this.vpOnboarderPager.getCurrentItem() - 1);
        } else if (i == R.id.ivNext && !isInLastPage) {
            this.vpOnboarderPager.setCurrentItem(this.vpOnboarderPager.getCurrentItem() + 1);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        int firstPagePosition = 0;
        int lastPagePosition = this.ahoyOnboarderAdapter.getCount() - 1;
        this.circleIndicatorView.setCurrentPage(position);
        this.circleIndicatorView.setCurrentPage(position);
        if (position == lastPagePosition) {
            this.fadeOut(this.circleIndicatorView);
            this.showFinish();
            this.fadeOut((View)this.ivNext);
            this.fadeIn((View)this.ivPrev);
        } else if (position == firstPagePosition) {
            this.fadeOut((View)this.ivPrev);
            this.fadeIn((View)this.ivNext);
            this.hideFinish();
            this.fadeIn(this.circleIndicatorView);
        } else {
            this.fadeIn(this.circleIndicatorView);
            this.hideFinish();
            this.fadeIn((View)this.ivPrev);
            this.fadeIn((View)this.ivNext);
        }
        if (this.solidBackground && this.pages.size() == this.colorList.size()) {
            this.backgroundImage.setBackgroundColor(ContextCompat.getColor((Context)this, (int)this.colorList.get(position)));
        }
    }

    public void onPageScrollStateChanged(int state) {
    }

    private void fadeOut(View v) {
        this.fadeOut(v, true);
    }

    private void fadeOut(final View v, boolean delay) {
        long duration = 0L;
        if (delay) {
            duration = 300L;
        }
        if (v.getVisibility() != 8) {
            AlphaAnimation fadeOut = new AlphaAnimation(1.0f, 0.0f);
            fadeOut.setInterpolator((Interpolator)new AccelerateInterpolator());
            fadeOut.setDuration(duration);
            fadeOut.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    v.setVisibility(8);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            v.startAnimation((Animation)fadeOut);
        }
    }

    private void fadeIn(final View v) {
        if (v.getVisibility() != 0) {
            AlphaAnimation fadeIn = new AlphaAnimation(0.0f, 1.0f);
            fadeIn.setInterpolator((Interpolator)new DecelerateInterpolator());
            fadeIn.setDuration(300L);
            fadeIn.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    v.setVisibility(0);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            v.startAnimation((Animation)fadeIn);
        }
    }

    private void showFinish() {
        this.btnSkip.setVisibility(0);
        this.btnSkip.animate().translationY(0.0f - this.dpToPixels(5, (Context)this)).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setDuration(500L).start();
    }

    private void hideFinish(boolean delay) {
        long duration = 0L;
        if (delay) {
            duration = 250L;
        }
        this.btnSkip.animate().translationY((float)this.btnSkip.getBottom() + this.dpToPixels(100, (Context)this)).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(duration).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                FancyWalkthroughActivity.this.btnSkip.setVisibility(0);
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        }).start();
    }

    private void hideFinish() {
        this.hideFinish(true);
    }

    private void hideActionBar() {
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().hide();
        }
    }

    public abstract void onFinishButtonPressed();

    public void showNavigationControls(boolean navigation) {
        if (navigation) {
            this.navigationControls.setVisibility(0);
        } else {
            this.navigationControls.setVisibility(8);
        }
    }

    public void setImageBackground(int resId) {
        this.backgroundImage.setImageResource(resId);
    }

    public void setColorBackground(@ColorRes int color2) {
        this.backgroundImage.setBackgroundColor(ContextCompat.getColor((Context)this, (int)color2));
    }

    public void setColorBackground(List<Integer> color2) {
        this.colorList = color2;
        this.solidBackground = true;
        this.backgroundImage.setBackgroundColor(ContextCompat.getColor((Context)this, (int)color2.get(0)));
    }

    public void setInactiveIndicatorColor(int color2) {
        this.circleIndicatorView.setInactiveIndicatorColor(color2);
    }

    public void setActiveIndicatorColor(int color2) {
        this.circleIndicatorView.setActiveIndicatorColor(color2);
    }

    @RequiresApi(api=16)
    public void setFinishButtonDrawableStyle(Drawable res) {
        this.btnSkip.setBackground(res);
    }

    public void setFinishButtonTitle(CharSequence title) {
        this.btnSkip.setText(title);
    }

    public void setFinishButtonTitle(@StringRes int titleResId) {
        this.btnSkip.setText(titleResId);
    }

    public void setFont(Typeface typeface) {
        this.btnSkip.setTypeface(typeface);
        this.typeface = typeface;
    }
}

