/*
 * Decompiled with CFR 0.152.
 */
package com.gigya.android.sdk.biometric.v23;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.os.CancellationSignal;
import androidx.vectordrawable.graphics.drawable.AnimatedVectorDrawableCompat;
import com.gigya.android.sdk.GigyaLogger;
import com.gigya.android.sdk.biometric.IGigyaBiometricCallback;
import com.gigya.android.sdk.biometric.R;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import java.util.concurrent.TimeUnit;

public class GigyaBiometricPromptV23
extends BottomSheetDialog
implements View.OnClickListener {
    private static final String LOG_TAG = "GigyaBiometricPromptV23";
    private TextView _title;
    private TextView _subtitle;
    private TextView _description;
    private TextView _indicatorText;
    private ImageView _indicatorImage;
    private IGigyaBiometricCallback _biometricCallback;
    private CancellationSignal _cancellationSignal;
    private boolean _animate = true;

    void setCancellationSignal(CancellationSignal signal) {
        this._cancellationSignal = signal;
    }

    GigyaBiometricPromptV23(@NonNull Context context, IGigyaBiometricCallback callback) {
        super(context);
        this._biometricCallback = callback;
        this.bindView();
        this.referenceViews();
    }

    private void bindView() {
        View bottomSheetView = this.getLayoutInflater().inflate(R.layout.dialog_gigya_biometric_prompt, null);
        this.setContentView(bottomSheetView);
    }

    private void referenceViews() {
        this._title = (TextView)this.findViewById(R.id.title_text);
        this._subtitle = (TextView)this.findViewById(R.id.subtitle_text);
        this._description = (TextView)this.findViewById(R.id.description_text);
        this._indicatorText = (TextView)this.findViewById(R.id.ind_text);
        this._indicatorImage = (ImageView)this.findViewById(R.id.ind_image);
        Button _cancelButton = (Button)this.findViewById(R.id.cancel_button);
        if (_cancelButton != null) {
            _cancelButton.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void dismiss() {
        if (this._cancellationSignal != null && !this._cancellationSignal.isCanceled()) {
            this._cancellationSignal.cancel();
        }
        super.dismiss();
    }

    void setAnimate(boolean animate) {
        this._animate = animate;
    }

    void setTitle(@NonNull String title) {
        if (this._title != null) {
            this._title.setText((CharSequence)title);
        }
    }

    void setSubtitle(@NonNull String subtitle) {
        if (this._subtitle != null) {
            this._subtitle.setText((CharSequence)subtitle);
        }
    }

    void setDescription(@Nullable String description) {
        if (this._description != null) {
            if (TextUtils.isEmpty((CharSequence)description)) {
                this._description.setVisibility(8);
                return;
            }
            this._description.setText((CharSequence)description);
        }
    }

    public void onClick(View v) {
        this._biometricCallback.onBiometricOperationCanceled();
        this.dismiss();
    }

    void onAuthenticationHelp(String helpString) {
        this.vibrate();
        this.helpState(helpString);
    }

    void onAuthenticationFailed() {
        this.onAuthenticationError(-1, "Fingerprint recognition failed");
    }

    void onAuthenticationError(int errMsgId, String errorString) {
        this.vibrate();
        this.errorState(errorString);
        switch (errMsgId) {
            case 7: 
            case 9: {
                GigyaLogger.error((String)LOG_TAG, (String)"Fingerprint authentication lockout error");
                break;
            }
            default: {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (GigyaBiometricPromptV23.this.isShowing()) {
                                GigyaBiometricPromptV23.this.resetState();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }, TimeUnit.SECONDS.toMillis(3L));
            }
        }
    }

    private void resetState() {
        if (this._indicatorText != null) {
            this._indicatorText.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.color_text_secondary));
            this._indicatorText.setText((CharSequence)this.getContext().getString(R.string.bio_touch_sensor));
        }
        if (this._indicatorImage == null) {
            return;
        }
        if (this._animate) {
            this.animateBackFromError();
        } else {
            this._indicatorImage.setImageResource(R.drawable.v_fingerprint);
        }
    }

    private void errorState(String errorString) {
        if (this._indicatorText != null) {
            this._indicatorText.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.color_error));
            if (errorString == null) {
                errorString = this.getContext().getString(R.string.bio_not_recognized);
            }
            this._indicatorText.setText((CharSequence)errorString);
        }
        if (this._indicatorImage == null) {
            return;
        }
        if (this._animate) {
            this.animateToError();
        } else {
            this._indicatorImage.setImageResource(R.drawable.v_error_info);
        }
    }

    private void helpState(String helpString) {
        if (this._indicatorText != null) {
            this._indicatorText.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.color_text_secondary));
            this._indicatorText.setText((CharSequence)helpString);
        }
        if (this._indicatorImage == null) {
            return;
        }
        if (this._animate) {
            this.animateToError();
        } else {
            this._indicatorImage.setImageResource(R.drawable.v_error_info);
        }
    }

    private void vibrate() {
        Vibrator v = (Vibrator)this.getContext().getSystemService("vibrator");
        if (Build.VERSION.SDK_INT >= 26) {
            long[] wave_time = new long[]{0L, 20L};
            int[] wave_amplitude = new int[]{0, 10};
            VibrationEffect vibrationEffect = VibrationEffect.createWaveform((long[])wave_time, (int[])wave_amplitude, (int)-1);
            v.vibrate(vibrationEffect);
        } else {
            v.vibrate(20L);
        }
    }

    private void animateToError() {
        int resId = R.drawable.av_fingerprint_to_error;
        AnimatedVectorDrawableCompat av = AnimatedVectorDrawableCompat.create((Context)this.getContext(), (int)resId);
        this._indicatorImage.setImageDrawable((Drawable)av);
        if (av != null) {
            av.start();
        }
    }

    private void animateBackFromError() {
        int resId = R.drawable.av_error_to_fingerprint;
        AnimatedVectorDrawableCompat av = AnimatedVectorDrawableCompat.create((Context)this.getContext(), (int)resId);
        this._indicatorImage.setImageDrawable((Drawable)av);
        if (av != null) {
            av.start();
        }
    }
}

