/*
 * Decompiled with CFR 0.152.
 */
package com.gigya.android.sdk.biometric;

import android.content.Context;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Pair;
import com.gigya.android.sdk.Config;
import com.gigya.android.sdk.GigyaLogger;
import com.gigya.android.sdk.biometric.BiometricKey;
import com.gigya.android.sdk.biometric.GigyaBiometric;
import com.gigya.android.sdk.biometric.IBiometricImpl;
import com.gigya.android.sdk.biometric.IGigyaBiometricCallback;
import com.gigya.android.sdk.biometric.IGigyaBiometricOperationCallback;
import com.gigya.android.sdk.encryption.ISecureKey;
import com.gigya.android.sdk.persistence.IPersistenceService;
import com.gigya.android.sdk.session.ISessionService;
import com.gigya.android.sdk.session.SessionInfo;
import com.gigya.android.sdk.utils.CipherUtils;
import com.gigya.android.sdk.utils.ObjectUtils;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.json.JSONObject;

public abstract class BiometricImpl
implements IBiometricImpl {
    private static final String LOG_TAG = "BiometricImpl";
    private static final String FINGERPRINT_KEY_NAME = "fingerprint";
    protected final Context _context;
    private final Config _config;
    private final ISessionService _sessionService;
    private final IPersistenceService _persistenceService;
    protected final ISecureKey _biometricKey;

    public BiometricImpl(Context context, Config config, ISessionService sessionService, IPersistenceService persistenceService) {
        this._context = context;
        this._config = config;
        this._sessionService = sessionService;
        this._persistenceService = persistenceService;
        this._biometricKey = new BiometricKey(this._persistenceService);
    }

    protected abstract void updateAnimationState(boolean var1);

    private void setSession(@Nullable Cipher cipher, @NonNull SessionInfo sessionInfo) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("sessionToken", (Object)sessionInfo.getSessionToken());
        jsonObject.put("sessionSecret", (Object)sessionInfo.getSessionSecret());
        jsonObject.put("expirationTime", sessionInfo.getExpirationTime());
        jsonObject.put("ucid", (Object)this._config.getUcid());
        jsonObject.put("gmid", (Object)this._config.getGmid());
        String plain = jsonObject.toString();
        if (cipher == null) {
            SecretKey key = this._biometricKey.getKey();
            cipher = this._biometricKey.getEncryptionCipher((Key)key);
        }
        Pair<String, String> encodedPair = this.encryptBiometricString(cipher, plain);
        this._persistenceService.add("GS_PREFS", encodedPair.first);
        this._persistenceService.add("IV_fingerprint", encodedPair.second);
        this._persistenceService.add("sessionProtectionType", (Object)"FINGERPRINT");
    }

    boolean okayToOptInOut() {
        return this._sessionService != null && this._sessionService.isValid();
    }

    boolean isOptIn() {
        String encryptionType = this._persistenceService.getString("sessionProtectionType", "DEFAULT");
        boolean optIn = ObjectUtils.safeEquals((Object)encryptionType, (Object)"FINGERPRINT");
        GigyaLogger.debug((String)LOG_TAG, (String)("isOptIn : " + String.valueOf(optIn)));
        return optIn;
    }

    boolean isLocked() {
        return !this._sessionService.isValid() && this.isOptIn();
    }

    protected synchronized void onSuccessfulAuthentication(Cipher cipher, GigyaBiometric.Action action, @NonNull IGigyaBiometricCallback biometricCallback) {
        switch (action) {
            case OPT_IN: {
                this.optIn(cipher, biometricCallback);
                break;
            }
            case OPT_OUT: {
                this.optOut(cipher, biometricCallback);
                break;
            }
            case UNLOCK: {
                this.unlock(cipher, biometricCallback);
                break;
            }
        }
    }

    private void optIn(@NonNull Cipher cipher, @NonNull IGigyaBiometricCallback biometricCallback) {
        String encryptionType = this._persistenceService.getString("sessionProtectionType", "DEFAULT");
        if (encryptionType.equals("FINGERPRINT")) {
            GigyaLogger.error((String)LOG_TAG, (String)"Fingerprint already opt-in");
            return;
        }
        SessionInfo sessionInfo = this._sessionService.getSession();
        if (sessionInfo == null) {
            GigyaLogger.error((String)LOG_TAG, (String)"Session is null Opt-In failed");
            return;
        }
        try {
            this.setSession(cipher, sessionInfo);
            biometricCallback.onBiometricOperationSuccess(GigyaBiometric.Action.OPT_IN);
        }
        catch (Exception ex) {
            ((BiometricKey)this._biometricKey).deleteKey();
            ex.printStackTrace();
            biometricCallback.onBiometricOperationFailed("Fingerprint optIn: " + ex.getMessage());
        }
    }

    private void optOut(@NonNull Cipher cipher, IGigyaBiometricCallback biometricCallback) {
        String encryptionType = this._persistenceService.getString("sessionProtectionType", "DEFAULT");
        if (encryptionType.equals("DEFAULT")) {
            GigyaLogger.error((String)LOG_TAG, (String)"Fingerprint already opt-out");
            return;
        }
        try {
            SessionInfo sessionInfo = this.decryptBiometricSession(cipher);
            this._persistenceService.add("sessionProtectionType", (Object)"DEFAULT");
            this._sessionService.setSession(sessionInfo);
            ((BiometricKey)this._biometricKey).deleteKey();
            biometricCallback.onBiometricOperationSuccess(GigyaBiometric.Action.OPT_OUT);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            biometricCallback.onBiometricOperationFailed("Fingerprint optOut: " + ex.getMessage());
        }
    }

    void lock(IGigyaBiometricOperationCallback biometricCallback) {
        this._sessionService.clear(false);
        biometricCallback.onBiometricOperationSuccess(GigyaBiometric.Action.LOCK);
    }

    private void unlock(@NonNull Cipher cipher, IGigyaBiometricCallback biometricCallback) {
        try {
            SessionInfo sessionInfo = this.decryptBiometricSession(cipher);
            this._sessionService.setSession(sessionInfo);
            this._sessionService.refreshSessionExpiration();
            biometricCallback.onBiometricOperationSuccess(GigyaBiometric.Action.UNLOCK);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            biometricCallback.onBiometricOperationFailed("Fingerprint unlock: " + ex.getMessage());
        }
    }

    private Pair<String, String> encryptBiometricString(Cipher cipher, String plain) throws Exception {
        byte[] encryptedBytes = cipher.doFinal(CipherUtils.toBytes((char[])plain.toCharArray()));
        byte[] ivBytes = cipher.getParameters().getParameterSpec(IvParameterSpec.class).getIV();
        String encodedSession = Base64.encodeToString((byte[])encryptedBytes, (int)0);
        String encodedIVSpec = Base64.encodeToString((byte[])ivBytes, (int)0);
        return new Pair((Object)encodedSession, (Object)encodedIVSpec);
    }

    private SessionInfo decryptBiometricSession(Cipher cipher) throws Exception {
        String encryptedSession = this._persistenceService.getString("GS_PREFS", null);
        byte[] encPLBytes = Base64.decode((String)encryptedSession, (int)0);
        byte[] bytePlainText = cipher.doFinal(encPLBytes);
        String plain = new String(CipherUtils.toChars((byte[])bytePlainText));
        JSONObject jsonObject = new JSONObject(plain);
        String sessionToken = jsonObject.has("sessionToken") ? jsonObject.getString("sessionToken") : null;
        String sessionSecret = jsonObject.has("sessionSecret") ? jsonObject.getString("sessionSecret") : null;
        long expirationTime = jsonObject.has("expirationTime") ? jsonObject.getLong("expirationTime") : 0L;
        String ucid = jsonObject.getString("ucid");
        this._config.setUcid(ucid);
        String gmid = jsonObject.getString("gmid");
        this._config.setGmid(gmid);
        return new SessionInfo(sessionSecret, sessionToken, expirationTime);
    }

    protected void onInvalidKey() {
        this._sessionService.clear(true);
        ((BiometricKey)this._biometricKey).deleteKey();
    }
}

