/*
 * Decompiled with CFR 0.152.
 */
package com.gigya.android.sdk.biometric.v28;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.hardware.biometrics.BiometricPrompt;
import android.os.CancellationSignal;
import android.security.keystore.KeyPermanentlyInvalidatedException;
import androidx.annotation.NonNull;
import com.gigya.android.sdk.Config;
import com.gigya.android.sdk.GigyaLogger;
import com.gigya.android.sdk.biometric.BiometricImpl;
import com.gigya.android.sdk.biometric.GigyaBiometric;
import com.gigya.android.sdk.biometric.GigyaPromptInfo;
import com.gigya.android.sdk.biometric.IGigyaBiometricCallback;
import com.gigya.android.sdk.biometric.R;
import com.gigya.android.sdk.encryption.EncryptionException;
import com.gigya.android.sdk.persistence.IPersistenceService;
import com.gigya.android.sdk.session.ISessionService;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

@TargetApi(value=28)
public class BiometricImplV28
extends BiometricImpl {
    private static final String LOG_TAG = "BiometricImplV28";

    public BiometricImplV28(Context context, Config config, ISessionService sessionService, IPersistenceService persistenceService) {
        super(context, config, sessionService, persistenceService);
    }

    @Override
    protected void updateAnimationState(boolean state) {
        throw new RuntimeException("Updating animation state is only available for Pre 28 Android versions");
    }

    @Override
    public synchronized void showPrompt(Activity activity, final GigyaBiometric.Action action, @NonNull GigyaPromptInfo gigyaPromptInfo, int encryptionMode, final @NonNull IGigyaBiometricCallback callback) {
        SecretKey key = this._biometricKey.getKey();
        if (key == null) {
            GigyaLogger.error((String)LOG_TAG, (String)"Unable to generate secret key from KeyStore API");
            return;
        }
        try {
            final Cipher cipher = encryptionMode == 2 ? this._biometricKey.getDecryptionCipher((Key)key) : this._biometricKey.getEncryptionCipher((Key)key);
            if (cipher != null) {
                BiometricPrompt prompt = new BiometricPrompt.Builder((Context)activity).setTitle((CharSequence)(gigyaPromptInfo.getTitle() != null ? gigyaPromptInfo.getTitle() : this._context.getString(R.string.bio_prompt_default_title))).setSubtitle((CharSequence)(gigyaPromptInfo.getSubtitle() != null ? gigyaPromptInfo.getSubtitle() : this._context.getString(R.string.bio_prompt_default_subtitle))).setDescription((CharSequence)(gigyaPromptInfo.getDescription() != null ? gigyaPromptInfo.getDescription() : this._context.getString(R.string.bio_prompt_default_description))).setNegativeButton((CharSequence)"Cancel", this._context.getMainExecutor(), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        callback.onBiometricOperationCanceled();
                    }
                }).build();
                BiometricPrompt.CryptoObject cryptoObject = new BiometricPrompt.CryptoObject(cipher);
                prompt.authenticate(cryptoObject, new CancellationSignal(), this._context.getMainExecutor(), new BiometricPrompt.AuthenticationCallback(){

                    public void onAuthenticationError(int errorCode, CharSequence errString) {
                        super.onAuthenticationError(errorCode, errString);
                        callback.onBiometricOperationFailed(errString.toString());
                    }

                    public void onAuthenticationHelp(int helpCode, CharSequence helpString) {
                        super.onAuthenticationHelp(helpCode, helpString);
                    }

                    public void onAuthenticationSucceeded(BiometricPrompt.AuthenticationResult result) {
                        super.onAuthenticationSucceeded(result);
                        BiometricImplV28.this.onSuccessfulAuthentication(cipher, action, callback);
                    }

                    public void onAuthenticationFailed() {
                        super.onAuthenticationFailed();
                        callback.onBiometricOperationFailed("Fingerprint recognition failed");
                    }
                });
            } else {
                GigyaLogger.error((String)LOG_TAG, (String)"Failed to initialize cipher");
                callback.onBiometricOperationFailed("Failed to initialize cipher");
            }
        }
        catch (EncryptionException encryptionException) {
            Exception ex = (Exception)encryptionException.getCause();
            if (ex instanceof KeyPermanentlyInvalidatedException) {
                GigyaLogger.error((String)LOG_TAG, (String)ex.getMessage());
                this.onInvalidKey();
                callback.onBiometricOperationFailed("Key invalidated");
            }
            GigyaLogger.error((String)LOG_TAG, (String)"Failed to initialize cipher");
            callback.onBiometricOperationFailed("Failed to initialize cipher");
        }
    }
}

