/*
 * Decompiled with CFR 0.152.
 */
package com.gigya.android.sdk.biometric;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import androidx.core.app.ActivityCompat;
import androidx.core.hardware.fingerprint.FingerprintManagerCompat;

class GigyaBiometricUtils {
    GigyaBiometricUtils() {
    }

    private static boolean isPermissionGranted(Context context) {
        return ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.USE_FINGERPRINT") == 0;
    }

    @SuppressLint(value={"MissingPermission"})
    static boolean isSupported(Context context) {
        if (!GigyaBiometricUtils.isPermissionGranted(context)) {
            return false;
        }
        FingerprintManagerCompat fingerprintManager = FingerprintManagerCompat.from((Context)context);
        return fingerprintManager.isHardwareDetected();
    }

    @SuppressLint(value={"MissingPermission"})
    static boolean hasEnrolledFingerprints(Context context) {
        if (!GigyaBiometricUtils.isPermissionGranted(context)) {
            return false;
        }
        FingerprintManagerCompat fingerprintManager = FingerprintManagerCompat.from((Context)context);
        return fingerprintManager.hasEnrolledFingerprints();
    }

    static boolean isPromptEnabled() {
        return Build.VERSION.SDK_INT >= 28;
    }
}

