/*
 * Decompiled with CFR 0.152.
 */
package com.gigya.android.sdk.biometric;

import android.app.Activity;
import android.content.Context;
import com.gigya.android.sdk.Gigya;
import com.gigya.android.sdk.GigyaLogger;
import com.gigya.android.sdk.biometric.BiometricImpl;
import com.gigya.android.sdk.biometric.GigyaBiometricUtils;
import com.gigya.android.sdk.biometric.GigyaPromptInfo;
import com.gigya.android.sdk.biometric.IGigyaBiometricCallback;
import com.gigya.android.sdk.biometric.IGigyaBiometricOperationCallback;
import com.gigya.android.sdk.biometric.v23.BiometricImplV23;
import com.gigya.android.sdk.biometric.v28.BiometricImplV28;
import com.gigya.android.sdk.containers.IoCContainer;
import com.gigya.android.sdk.reporting.ReportingManager;

public class GigyaBiometric {
    public static final String VERSION = "2.0.0";
    private static final String LOG_TAG = "GigyaBiometric";
    private static GigyaBiometric _sharedInstance;
    private BiometricImpl _impl;
    private boolean _isAvailable;

    public static synchronized GigyaBiometric getInstance() {
        if (_sharedInstance == null) {
            IoCContainer container = Gigya.getContainer();
            container.bind(GigyaBiometric.class, GigyaBiometric.class, true);
            container.bind(BiometricImpl.class, GigyaBiometricUtils.isPromptEnabled() ? BiometricImplV28.class : BiometricImplV23.class, true);
            try {
                _sharedInstance = (GigyaBiometric)container.get(GigyaBiometric.class);
                GigyaLogger.debug((String)LOG_TAG, (String)"Instantiation version: 2.0.0");
            }
            catch (Exception e) {
                GigyaLogger.error((String)LOG_TAG, (String)"Error creating Gigya Biometric SDK (did you forget to Gigya.setApplication?");
                e.printStackTrace();
                throw new RuntimeException("Error instantiating Gigya Biometric SDK (did you forget to Gigya.setApplication?");
            }
        }
        return _sharedInstance;
    }

    protected GigyaBiometric(Context context, BiometricImpl impl) {
        this._isAvailable = this.verifyBiometricSupport(context);
        if (!this._isAvailable) {
            return;
        }
        this._impl = impl;
    }

    public boolean isAvailable() {
        return this._isAvailable;
    }

    public void setAnimationForPrePieDevices(boolean animate) {
        if (!GigyaBiometricUtils.isPromptEnabled()) {
            this._impl.updateAnimationState(animate);
        }
    }

    private boolean verifyBiometricSupport(Context context) {
        if (!GigyaBiometricUtils.isSupported(context)) {
            ReportingManager.get().error(VERSION, "biometric", "Fingerprint is not supported on this device. No sensor hardware was detected");
            GigyaLogger.error((String)LOG_TAG, (String)"Fingerprint is not supported on this device. No sensor hardware was detected");
            return false;
        }
        if (!GigyaBiometricUtils.hasEnrolledFingerprints(context)) {
            ReportingManager.get().error(VERSION, "biometric", "No fingerprint data available on device. Please enroll at least one fingerprint");
            GigyaLogger.error((String)LOG_TAG, (String)"No fingerprint data available on device. Please enroll at least one fingerprint");
            return false;
        }
        return true;
    }

    public boolean isOptIn() {
        return this._impl != null && this._impl.isOptIn();
    }

    public boolean isLocked() {
        return this._impl != null && this._impl.isLocked();
    }

    public void optIn(Activity activity, GigyaPromptInfo gigyaPromptInfo, IGigyaBiometricCallback biometricCallback) {
        GigyaLogger.debug((String)LOG_TAG, (String)"optIn: ");
        if (this._impl.okayToOptInOut()) {
            this._impl.showPrompt(activity, Action.OPT_IN, gigyaPromptInfo, 1, biometricCallback);
        } else {
            String failedMessage = "Session is invalid. Opt in operation is unavailable";
            GigyaLogger.error((String)LOG_TAG, (String)"Session is invalid. Opt in operation is unavailable");
            biometricCallback.onBiometricOperationFailed("Session is invalid. Opt in operation is unavailable");
        }
    }

    public void optOut(Activity activity, GigyaPromptInfo gigyaPromptInfo, IGigyaBiometricCallback biometricCallback) {
        GigyaLogger.debug((String)LOG_TAG, (String)"optOut: ");
        if (this._impl.isLocked()) {
            GigyaLogger.error((String)LOG_TAG, (String)"optOut: Need to unlock first before trying Opt-out operation");
            String failedMessage = "Please unlock session before trying to Opt-out";
            biometricCallback.onBiometricOperationFailed("Please unlock session before trying to Opt-out");
            return;
        }
        if (this._impl.okayToOptInOut()) {
            this._impl.showPrompt(activity, Action.OPT_OUT, gigyaPromptInfo, 2, biometricCallback);
        } else {
            GigyaLogger.error((String)LOG_TAG, (String)"optOut: Session is invalid. Opt in operation is unavailable");
            String failedMessage = "Invalid session. Unable to perform biometric operation";
            biometricCallback.onBiometricOperationFailed("Invalid session. Unable to perform biometric operation");
        }
    }

    public void lock(IGigyaBiometricOperationCallback biometricCallback) {
        GigyaLogger.debug((String)LOG_TAG, (String)"lock: ");
        if (this._impl.isOptIn()) {
            this._impl.lock(biometricCallback);
        } else {
            String failedMessage = "Not Opt-In";
            GigyaLogger.error((String)LOG_TAG, (String)"Not Opt-In");
            biometricCallback.onBiometricOperationFailed("Not Opt-In");
        }
    }

    public void unlock(Activity activity, GigyaPromptInfo gigyaPromptInfo, IGigyaBiometricCallback biometricCallback) {
        GigyaLogger.debug((String)LOG_TAG, (String)"unlock: ");
        if (this._impl.isOptIn()) {
            this._impl.showPrompt(activity, Action.UNLOCK, gigyaPromptInfo, 2, biometricCallback);
        } else {
            String failedMessage = "Not Opt-In";
            GigyaLogger.error((String)LOG_TAG, (String)"Not Opt-In");
            biometricCallback.onBiometricOperationFailed("Not Opt-In");
        }
    }

    public static enum Action {
        OPT_IN,
        OPT_OUT,
        LOCK,
        UNLOCK;

    }
}

