/*
 * Decompiled with CFR 0.152.
 */
package com.ruffian.library.widget.rounded;

import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class RoundDrawable
extends Drawable {
    private Bitmap mBitmap;
    private final int mBitmapWidth;
    private final int mBitmapHeight;
    private final RectF mBitmapRect = new RectF();
    private final Paint mBitmapPaint;
    private final Paint mBorderPaint;
    private final RectF mBorderRect = new RectF();
    private final RectF mDrawableRect = new RectF();
    private Path mPath = new Path();
    private RectF mRectF = new RectF();
    private final RectF mBounds = new RectF();
    private final RectF mBoundsFinal = new RectF();
    private boolean mRebuildShader = true;
    private final Matrix mShaderMatrix = new Matrix();
    private ImageView.ScaleType mScaleType = ImageView.ScaleType.FIT_CENTER;
    private float mCorner = -1.0f;
    private float mCornerTopLeft = 0.0f;
    private float mCornerTopRight = 0.0f;
    private float mCornerBottomLeft = 0.0f;
    private float mCornerBottomRight = 0.0f;
    private float[] mCornerRadii = new float[8];
    private float mBorderWidth = 0.0f;
    private int mBorderColor = -16777216;
    private boolean mCircle = true;

    public RoundDrawable(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.mBitmapWidth = bitmap.getWidth();
        this.mBitmapHeight = bitmap.getHeight();
        this.mBitmapRect.set(0.0f, 0.0f, (float)this.mBitmapWidth, (float)this.mBitmapHeight);
        this.mBitmapPaint = new Paint(1);
        this.mBitmapPaint.setStyle(Paint.Style.FILL);
        this.mBitmapPaint.setAntiAlias(true);
        this.mBorderPaint = new Paint(1);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setAntiAlias(true);
        this.updateBorder();
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mBoundsFinal.set(bounds);
        this.updateShaderMatrix();
        this.updateConner();
    }

    public void setAlpha(int alpha) {
        this.mBitmapPaint.setAlpha(alpha);
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mBitmapPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.mRebuildShader) {
            BitmapShader bitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            bitmapShader.setLocalMatrix(this.mShaderMatrix);
            this.mBitmapPaint.setShader((Shader)bitmapShader);
            this.mRebuildShader = false;
        }
        if (this.mCircle) {
            float cx = this.mDrawableRect.width() / 2.0f + this.mDrawableRect.left;
            float cy = this.mDrawableRect.height() / 2.0f + this.mDrawableRect.top;
            float radiusX = this.mDrawableRect.width() / 2.0f;
            float radiusY = this.mDrawableRect.height() / 2.0f;
            float radiusDrawable = Math.min(radiusX, radiusY);
            float radiusBitmap = Math.min(this.mBitmapHeight, this.mBitmapWidth);
            float radius = Math.min(radiusBitmap, radiusDrawable);
            canvas.drawCircle(cx, cy, radius, this.mBitmapPaint);
            if (this.mBorderWidth > 0.0f) {
                cx = this.mBorderRect.width() / 2.0f + this.mBorderRect.left;
                cy = this.mBorderRect.height() / 2.0f + this.mBorderRect.top;
                radiusX = this.mBorderRect.width() / 2.0f;
                radiusY = this.mBorderRect.height() / 2.0f;
                radiusDrawable = Math.min(radiusX, radiusY);
                radiusBitmap = Math.min(this.mBitmapHeight, this.mBitmapWidth);
                radius = Math.min(radiusBitmap, radiusDrawable);
                canvas.drawCircle(cx, cy, radius, this.mBorderPaint);
            }
        } else {
            this.updateDrawablePath();
            canvas.drawPath(this.mPath, this.mBitmapPaint);
            if (this.mBorderWidth > 0.0f) {
                this.updateBorderPath();
                canvas.drawPath(this.mPath, this.mBorderPaint);
            }
        }
    }

    private void updateConner() {
        if (this.mCorner >= 0.0f) {
            for (int i = 0; i < this.mCornerRadii.length; ++i) {
                this.mCornerRadii[i] = this.mCorner;
            }
            return;
        }
        if (this.mCorner < 0.0f) {
            this.mCornerRadii[0] = this.mCornerTopLeft;
            this.mCornerRadii[1] = this.mCornerTopLeft;
            this.mCornerRadii[2] = this.mCornerTopRight;
            this.mCornerRadii[3] = this.mCornerTopRight;
            this.mCornerRadii[4] = this.mCornerBottomRight;
            this.mCornerRadii[5] = this.mCornerBottomRight;
            this.mCornerRadii[6] = this.mCornerBottomLeft;
            this.mCornerRadii[7] = this.mCornerBottomLeft;
            return;
        }
    }

    private void updateDrawablePath() {
        this.mPath.reset();
        this.mPath.addRoundRect(this.mDrawableRect, this.mCornerRadii, Path.Direction.CCW);
    }

    private void updateBorderPath() {
        this.mPath.reset();
        this.mPath.addRoundRect(this.mBorderRect, this.mCornerRadii, Path.Direction.CCW);
    }

    private void updateShaderMatrix() {
        float dx = 0.0f;
        float dy = 0.0f;
        float half = this.mBorderWidth / 2.0f;
        this.mBounds.set(this.mBoundsFinal);
        switch (this.mScaleType) {
            case CENTER_INSIDE: {
                float width;
                float height;
                float scale;
                if ((float)this.mBitmapWidth <= this.mBounds.width() && (float)this.mBitmapHeight <= this.mBounds.height()) {
                    scale = 1.0f;
                    height = this.mBitmapHeight;
                    width = this.mBitmapWidth;
                } else {
                    scale = Math.min(this.mBounds.width() / (float)this.mBitmapWidth, this.mBounds.height() / (float)this.mBitmapHeight);
                    if (this.mBounds.height() < this.mBounds.width()) {
                        height = this.mBounds.height();
                        width = (float)this.mBitmapWidth * scale;
                    } else if (this.mBounds.height() > this.mBounds.width()) {
                        height = (float)this.mBitmapHeight * scale;
                        width = this.mBounds.width();
                    } else {
                        height = (float)this.mBitmapHeight * scale;
                        width = (float)this.mBitmapWidth * scale;
                    }
                }
                dx = (int)((this.mBounds.width() - (float)this.mBitmapWidth * scale) * 0.5f + 0.5f);
                dy = (int)((this.mBounds.height() - (float)this.mBitmapHeight * scale) * 0.5f + 0.5f);
                this.mRectF = new RectF(dx, dy, width + dx, height + dy);
                this.mRectF.inset(this.mCircle ? this.mBorderWidth : half, this.mCircle ? this.mBorderWidth : half);
                this.mShaderMatrix.reset();
                this.mShaderMatrix.setScale(scale, scale);
                this.mShaderMatrix.postTranslate(dx, dy);
                break;
            }
            case CENTER: {
                float height = Math.min(this.mBounds.height(), this.mBitmapRect.height());
                float width = Math.min(this.mBounds.width(), this.mBitmapRect.width());
                float cutOrMarginH = this.mBounds.height() - this.mBitmapRect.height();
                float cutOrMarginW = this.mBounds.width() - this.mBitmapRect.width();
                float halfH = cutOrMarginH / 2.0f;
                float halfW = cutOrMarginW / 2.0f;
                float top = halfH > 0.0f ? halfH : 0.0f;
                float left = halfW > 0.0f ? halfW : 0.0f;
                dx = halfW;
                dy = halfH;
                this.mRectF = new RectF(left, top, left + width, top + height);
                this.mRectF.inset(this.mCircle ? this.mBorderWidth : half, this.mCircle ? this.mBorderWidth : half);
                this.mShaderMatrix.reset();
                this.mShaderMatrix.postTranslate((float)((int)(dx + 0.5f)) + half, (float)((int)(dy + 0.5f)) + half);
                break;
            }
            case CENTER_CROP: {
                float scale;
                this.mRectF.set(this.mBounds);
                this.mRectF.inset(this.mCircle ? this.mBorderWidth : half, this.mCircle ? this.mBorderWidth : half);
                if ((float)this.mBitmapWidth * this.mRectF.height() > this.mRectF.width() * (float)this.mBitmapHeight) {
                    scale = this.mRectF.height() / (float)this.mBitmapHeight;
                    dx = (this.mRectF.width() - (float)this.mBitmapWidth * scale) * 0.5f;
                } else {
                    scale = this.mRectF.width() / (float)this.mBitmapWidth;
                    dy = (this.mRectF.height() - (float)this.mBitmapHeight * scale) * 0.5f;
                }
                this.mShaderMatrix.reset();
                this.mShaderMatrix.setScale(scale, scale);
                this.mShaderMatrix.postTranslate((float)((int)(dx + 0.5f)) + half, (float)((int)(dy + 0.5f)) + half);
                break;
            }
            default: {
                this.mBounds.inset(this.mCircle ? this.mBorderWidth : half, this.mCircle ? this.mBorderWidth : half);
                this.mRectF.set(this.mBitmapRect);
                this.mShaderMatrix.setRectToRect(this.mBitmapRect, this.mBounds, RoundDrawable.scaleTypeToScaleToFit(this.mScaleType));
                this.mShaderMatrix.mapRect(this.mRectF);
                this.mShaderMatrix.setRectToRect(this.mBitmapRect, this.mRectF, Matrix.ScaleToFit.FILL);
                break;
            }
            case FIT_XY: {
                this.mBounds.inset(this.mCircle ? this.mBorderWidth : half, this.mCircle ? this.mBorderWidth : half);
                this.mRectF.set(this.mBounds);
                this.mShaderMatrix.reset();
                this.mShaderMatrix.setRectToRect(this.mBitmapRect, this.mRectF, Matrix.ScaleToFit.FILL);
            }
        }
        if (this.mCircle) {
            this.mBorderRect.set(this.mRectF.left - half, this.mRectF.top - half, this.mRectF.right + half, this.mRectF.bottom + half);
        } else {
            this.mBorderRect.set(this.mBoundsFinal);
            this.mBorderRect.inset(half, half);
        }
        this.mDrawableRect.set(this.mRectF);
        this.mRebuildShader = true;
    }

    private void updateBorder() {
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStrokeWidth(this.mBorderWidth);
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void setParams(ImageView.ScaleType scaleType, float borderWidth, int borderColor, boolean circle, float corner, float topLeft, float topRight, float bottomLeft, float bottomRight) {
        if (scaleType == null) {
            scaleType = ImageView.ScaleType.FIT_CENTER;
        }
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
        }
        this.mBorderWidth = borderWidth;
        this.mBorderColor = borderColor;
        this.updateBorder();
        this.mCircle = circle;
        this.mCorner = corner;
        this.mCornerTopLeft = topLeft;
        this.mCornerTopRight = topRight;
        this.mCornerBottomLeft = bottomLeft;
        this.mCornerBottomRight = bottomRight;
        this.updateConner();
        this.updateShaderMatrix();
        this.invalidateSelf();
    }

    public RoundDrawable setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType == null) {
            scaleType = ImageView.ScaleType.FIT_CENTER;
        }
        if (this.mScaleType != scaleType) {
            this.mScaleType = scaleType;
            this.updateShaderMatrix();
            this.invalidateSelf();
        }
        return this;
    }

    public RoundDrawable setCircle(boolean circle) {
        this.mCircle = circle;
        this.updateShaderMatrix();
        this.invalidateSelf();
        return this;
    }

    public RoundDrawable setBorderWidth(float borderWidth) {
        this.mBorderWidth = borderWidth;
        this.updateBorder();
        this.updateShaderMatrix();
        this.invalidateSelf();
        return this;
    }

    public RoundDrawable setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
        this.updateBorder();
        this.invalidateSelf();
        return this;
    }

    public RoundDrawable setConner(float corner, float topLeft, float topRight, float bottomLeft, float bottomRight) {
        this.mCorner = corner;
        this.mCornerTopLeft = topLeft;
        this.mCornerTopRight = topRight;
        this.mCornerBottomLeft = bottomLeft;
        this.mCornerBottomRight = bottomRight;
        this.updateConner();
        this.invalidateSelf();
        return this;
    }

    public static RoundDrawable fromBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            return new RoundDrawable(bitmap);
        }
        return null;
    }

    public static Drawable fromDrawable(Drawable drawable) {
        if (drawable != null) {
            if (drawable instanceof RoundDrawable) {
                return drawable;
            }
            if (drawable instanceof LayerDrawable) {
                Drawable.ConstantState cs = drawable.mutate().getConstantState();
                LayerDrawable ld = (LayerDrawable)(cs != null ? cs.newDrawable() : drawable);
                int num = ld.getNumberOfLayers();
                for (int i = 0; i < num; ++i) {
                    Drawable d = ld.getDrawable(i);
                    ld.setDrawableByLayerId(ld.getId(i), RoundDrawable.fromDrawable(d));
                }
                return ld;
            }
            Bitmap bm = RoundDrawable.drawableToBitmap(drawable);
            if (bm != null) {
                return new RoundDrawable(bm);
            }
        }
        return drawable;
    }

    public static Bitmap drawableToBitmap(Drawable drawable) {
        Bitmap bitmap;
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        int width = Math.max(drawable.getIntrinsicWidth(), 2);
        int height = Math.max(drawable.getIntrinsicHeight(), 2);
        try {
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
        }
        catch (Throwable e) {
            e.printStackTrace();
            bitmap = null;
        }
        return bitmap;
    }

    private static Matrix.ScaleToFit scaleTypeToScaleToFit(ImageView.ScaleType st) {
        switch (st) {
            case FIT_XY: {
                return Matrix.ScaleToFit.FILL;
            }
            case FIT_START: {
                return Matrix.ScaleToFit.START;
            }
            case FIT_END: {
                return Matrix.ScaleToFit.END;
            }
            case FIT_CENTER: {
                return Matrix.ScaleToFit.CENTER;
            }
        }
        return Matrix.ScaleToFit.CENTER;
    }
}

