/*
 * Decompiled with CFR 0.152.
 */
package com.github.hiteshsondhi88.libffmpeg;

import android.content.Context;
import android.text.TextUtils;
import com.github.hiteshsondhi88.libffmpeg.CommandResult;
import com.github.hiteshsondhi88.libffmpeg.CpuArchHelper;
import com.github.hiteshsondhi88.libffmpeg.FFmpegExecuteAsyncTask;
import com.github.hiteshsondhi88.libffmpeg.FFmpegExecuteResponseHandler;
import com.github.hiteshsondhi88.libffmpeg.FFmpegInterface;
import com.github.hiteshsondhi88.libffmpeg.FFmpegLoadBinaryResponseHandler;
import com.github.hiteshsondhi88.libffmpeg.FFmpegLoadLibraryAsyncTask;
import com.github.hiteshsondhi88.libffmpeg.FileUtils;
import com.github.hiteshsondhi88.libffmpeg.Log;
import com.github.hiteshsondhi88.libffmpeg.R;
import com.github.hiteshsondhi88.libffmpeg.ShellCommand;
import com.github.hiteshsondhi88.libffmpeg.Util;
import com.github.hiteshsondhi88.libffmpeg.exceptions.FFmpegCommandAlreadyRunningException;
import com.github.hiteshsondhi88.libffmpeg.exceptions.FFmpegNotSupportedException;
import java.lang.reflect.Array;
import java.util.Map;

public class FFmpeg
implements FFmpegInterface {
    private final Context context;
    private FFmpegExecuteAsyncTask ffmpegExecuteAsyncTask;
    private FFmpegLoadLibraryAsyncTask ffmpegLoadLibraryAsyncTask;
    private static final long MINIMUM_TIMEOUT = 10000L;
    private long timeout = Long.MAX_VALUE;
    private static FFmpeg instance = null;

    private FFmpeg(Context context) {
        this.context = context.getApplicationContext();
        Log.setDEBUG(Util.isDebug(this.context));
    }

    public static FFmpeg getInstance(Context context) {
        if (instance == null) {
            instance = new FFmpeg(context);
        }
        return instance;
    }

    @Override
    public void loadBinary(FFmpegLoadBinaryResponseHandler ffmpegLoadBinaryResponseHandler) throws FFmpegNotSupportedException {
        String cpuArchNameFromAssets = null;
        switch (CpuArchHelper.getCpuArch()) {
            case x86: {
                Log.i("Loading FFmpeg for x86 CPU");
                cpuArchNameFromAssets = "x86";
                break;
            }
            case ARMv7: {
                Log.i("Loading FFmpeg for armv7 CPU");
                cpuArchNameFromAssets = "armeabi-v7a";
                break;
            }
            case NONE: {
                throw new FFmpegNotSupportedException("Device not supported");
            }
        }
        if (TextUtils.isEmpty(cpuArchNameFromAssets)) {
            throw new FFmpegNotSupportedException("Device not supported");
        }
        this.ffmpegLoadLibraryAsyncTask = new FFmpegLoadLibraryAsyncTask(this.context, cpuArchNameFromAssets, ffmpegLoadBinaryResponseHandler);
        this.ffmpegLoadLibraryAsyncTask.execute(new Void[0]);
    }

    @Override
    public void execute(Map<String, String> environvenmentVars, String[] cmd, FFmpegExecuteResponseHandler ffmpegExecuteResponseHandler) throws FFmpegCommandAlreadyRunningException {
        if (this.ffmpegExecuteAsyncTask != null && !this.ffmpegExecuteAsyncTask.isProcessCompleted()) {
            throw new FFmpegCommandAlreadyRunningException("FFmpeg command is already running, you are only allowed to run single command at a time");
        }
        if (cmd.length == 0) {
            throw new IllegalArgumentException("shell command cannot be empty");
        }
        String[] ffmpegBinary = new String[]{FileUtils.getFFmpeg(this.context, environvenmentVars)};
        String[] command = this.concatenate(ffmpegBinary, cmd);
        this.ffmpegExecuteAsyncTask = new FFmpegExecuteAsyncTask(command, this.timeout, ffmpegExecuteResponseHandler);
        this.ffmpegExecuteAsyncTask.execute(new Void[0]);
    }

    public <T> T[] concatenate(T[] a, T[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    @Override
    public void execute(String[] cmd, FFmpegExecuteResponseHandler ffmpegExecuteResponseHandler) throws FFmpegCommandAlreadyRunningException {
        this.execute(null, cmd, ffmpegExecuteResponseHandler);
    }

    @Override
    public String getDeviceFFmpegVersion() throws FFmpegCommandAlreadyRunningException {
        ShellCommand shellCommand = new ShellCommand();
        CommandResult commandResult = shellCommand.runWaitFor(new String[]{FileUtils.getFFmpeg(this.context), "-version"});
        if (commandResult.success) {
            return commandResult.output.split(" ")[2];
        }
        return "";
    }

    @Override
    public String getLibraryFFmpegVersion() {
        return this.context.getString(R.string.shipped_ffmpeg_version);
    }

    @Override
    public boolean isFFmpegCommandRunning() {
        return this.ffmpegExecuteAsyncTask != null && !this.ffmpegExecuteAsyncTask.isProcessCompleted();
    }

    @Override
    public boolean killRunningProcesses() {
        return Util.killAsync(this.ffmpegLoadLibraryAsyncTask) || Util.killAsync(this.ffmpegExecuteAsyncTask);
    }

    @Override
    public void setTimeout(long timeout) {
        if (timeout >= 10000L) {
            this.timeout = timeout;
        }
    }
}

