/*
 * Decompiled with CFR 0.152.
 */
package com.maple.recorder.recording;

import com.maple.recorder.recording.AudioRecordConfig;

public class WavHeader {
    private AudioRecordConfig config;
    private long totalAudioLength;

    WavHeader(AudioRecordConfig config, long totalAudioLength) {
        this.config = config;
        this.totalAudioLength = totalAudioLength;
    }

    public byte[] toBytes() {
        long sampleRateInHz = this.config.frequency();
        int channels = this.config.channelPositionMask() == 16 ? 1 : 2;
        byte bitsPerSample = this.config.bitsPerSample();
        return this.wavFileHeader(this.totalAudioLength - 44L, this.totalAudioLength - 44L + 36L, sampleRateInHz, channels, (long)bitsPerSample * sampleRateInHz * (long)channels / 8L, bitsPerSample);
    }

    private byte[] wavFileHeader(long totalAudioLen, long totalDataLen, long longSampleRate, int channels, long byteRate, byte bitsPerSample) {
        byte[] header = new byte[]{82, 73, 70, 70, (byte)(totalDataLen & 0xFFL), (byte)(totalDataLen >> 8 & 0xFFL), (byte)(totalDataLen >> 16 & 0xFFL), (byte)(totalDataLen >> 24 & 0xFFL), 87, 65, 86, 69, 102, 109, 116, 32, 16, 0, 0, 0, 1, 0, (byte)channels, 0, (byte)(longSampleRate & 0xFFL), (byte)(longSampleRate >> 8 & 0xFFL), (byte)(longSampleRate >> 16 & 0xFFL), (byte)(longSampleRate >> 24 & 0xFFL), (byte)(byteRate & 0xFFL), (byte)(byteRate >> 8 & 0xFFL), (byte)(byteRate >> 16 & 0xFFL), (byte)(byteRate >> 24 & 0xFFL), (byte)(channels * (bitsPerSample / 8)), 0, bitsPerSample, 0, 100, 97, 116, 97, (byte)(totalAudioLen & 0xFFL), (byte)(totalAudioLen >> 8 & 0xFFL), (byte)(totalAudioLen >> 16 & 0xFFL), (byte)(totalAudioLen >> 24 & 0xFFL)};
        return header;
    }
}

