/*
 * Decompiled with CFR 0.152.
 */
package com.maple.recorder.recording;

import android.media.AudioRecord;
import com.maple.recorder.recording.AudioRecordConfig;
import com.maple.recorder.recording.PullTransport;
import com.maple.recorder.recording.Recorder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BaseDataRecorder
implements Recorder {
    protected PullTransport pullTransport;
    protected AudioRecordConfig config;
    protected int pullSizeInBytes;
    protected File file;
    private AudioRecord audioRecord;
    private OutputStream outputStream;
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    private Runnable recordingTask = new Runnable(){

        @Override
        public void run() {
            BaseDataRecorder.this.startRecord();
        }
    };

    protected BaseDataRecorder(File file, AudioRecordConfig config, PullTransport pullTransport) {
        this.file = file;
        this.config = config;
        this.pullTransport = pullTransport;
        this.pullSizeInBytes = AudioRecord.getMinBufferSize((int)config.frequency(), (int)config.channelPositionMask(), (int)config.audioEncoding());
    }

    private void startRecord() {
        try {
            if (this.audioRecord == null) {
                this.audioRecord = new AudioRecord(this.config.audioSource(), this.config.frequency(), this.config.channelPositionMask(), this.config.audioEncoding(), this.pullSizeInBytes);
            }
            if (this.outputStream == null) {
                this.outputStream = new FileOutputStream(this.file);
            }
            this.audioRecord.startRecording();
            this.pullTransport.isEnableToBePulled(true);
            this.pullTransport.startPoolingAndWriting(this.audioRecord, this.pullSizeInBytes, this.outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void startRecording() {
        this.executorService.submit(this.recordingTask);
    }

    @Override
    public void pauseRecording() {
        this.pullTransport.isEnableToBePulled(false);
    }

    @Override
    public void resumeRecording() {
        this.startRecording();
    }

    @Override
    public void stopRecording() {
        this.pauseRecording();
        if (this.audioRecord != null) {
            this.audioRecord.stop();
            this.audioRecord.release();
            this.audioRecord = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
                this.outputStream.close();
                this.outputStream = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

