/*
 * Decompiled with CFR 0.152.
 */
package com.maple.recorder.recording;

public interface AudioRecordConfig {
    public int channelPositionMask();

    public int audioSource();

    public int frequency();

    public int audioEncoding();

    public byte bitsPerSample();

    public static class Default
    implements AudioRecordConfig {
        private final int audioSource;
        private final int channelPositionMask;
        private final int frequency;
        private final int audioEncoding;

        public Default() {
            this.audioSource = 1;
            this.audioEncoding = 2;
            this.channelPositionMask = 16;
            this.frequency = 44100;
        }

        public Default(int audioSource, int audioEncoding, int channelPositionMask, int frequency) {
            this.audioSource = audioSource;
            this.audioEncoding = audioEncoding;
            this.channelPositionMask = channelPositionMask;
            this.frequency = frequency;
        }

        @Override
        public int channelPositionMask() {
            return this.channelPositionMask;
        }

        @Override
        public int audioSource() {
            return this.audioSource;
        }

        @Override
        public int frequency() {
            return this.frequency;
        }

        @Override
        public int audioEncoding() {
            return this.audioEncoding;
        }

        @Override
        public byte bitsPerSample() {
            if (this.audioEncoding == 2) {
                return 16;
            }
            if (this.audioEncoding == 3) {
                return 8;
            }
            return 16;
        }
    }
}

