/*
 * Decompiled with CFR 0.152.
 */
package com.maple.recorder.player;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.media.MediaPlayer;
import android.view.View;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import com.maple.recorder.R;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class PlayDialog
extends Dialog {
    ImageButton ib_play;
    ImageView iv_cancel;
    SeekBar sb_bar;
    TextView tv_file_name;
    TextView tv_left_time;
    TextView tv_right_time;
    File file;
    MediaPlayer player;
    Activity activity;

    public PlayDialog(Activity activity) {
        super((Context)activity, R.style.CustomDialog);
        this.activity = activity;
        this.getWindow().getAttributes().gravity = 17;
        this.setCancelable(true);
        this.initView();
        this.initListener();
    }

    private void initView() {
        this.setContentView(R.layout.dialog_play_view);
        this.ib_play = (ImageButton)this.findViewById(R.id.ib_play);
        this.iv_cancel = (ImageView)this.findViewById(R.id.iv_cancel);
        this.sb_bar = (SeekBar)this.findViewById(R.id.sb_bar);
        this.tv_file_name = (TextView)this.findViewById(R.id.tv_file_name);
        this.tv_left_time = (TextView)this.findViewById(R.id.tv_left_time);
        this.tv_right_time = (TextView)this.findViewById(R.id.tv_right_time);
        this.tv_left_time.setText((CharSequence)"0:00");
        this.tv_right_time.setText((CharSequence)"0:40");
    }

    private void initListener() {
        this.iv_cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PlayDialog.this.dismiss();
            }
        });
        this.ib_play.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PlayDialog.this.clickPlay();
            }
        });
        this.sb_bar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
    }

    public void clickPlay() {
        if (!this.isPlaying()) {
            this.startPlaying();
        } else {
            this.pausePlay();
        }
    }

    public PlayDialog addWavFile(File file) {
        this.file = file;
        try {
            this.player = new MediaPlayer();
            this.player.setDataSource(file.getAbsolutePath());
            this.player.prepare();
            this.player.setLooping(true);
            this.player.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    PlayDialog.this.stopPlaying();
                }
            });
            int duration = this.player.getDuration();
            this.sb_bar.setProgress(0);
            this.sb_bar.setMax(duration);
            this.tv_right_time.setText((CharSequence)this.formatTime(duration));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public void showDialog() {
        this.showDialog(true);
    }

    public void showDialog(boolean cancelable) {
        this.setCancelable(cancelable);
        this.show();
    }

    public void dismiss() {
        this.stopPlaying();
        if (this.player != null) {
            this.player = null;
        }
        super.dismiss();
    }

    public String formatTime(int ms) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("m:ss");
        return dateFormat.format(new Date(ms));
    }

    public void startPlaying() {
        if (this.player != null) {
            this.player.start();
            this.ib_play.setBackgroundResource(R.drawable.ic_pause);
            TimerTask mTimerTask = new TimerTask(){

                @Override
                public void run() {
                    PlayDialog.this.activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            if (PlayDialog.this.isPlaying()) {
                                int curPosition = PlayDialog.this.player.getCurrentPosition();
                                PlayDialog.this.sb_bar.setProgress(curPosition);
                                PlayDialog.this.tv_left_time.setText((CharSequence)PlayDialog.this.formatTime(curPosition));
                            }
                        }
                    });
                }
            };
            new Timer().schedule(mTimerTask, 0L, 10L);
        }
    }

    public void pausePlay() {
        if (this.player != null) {
            this.player.pause();
            this.ib_play.setBackgroundResource(R.drawable.ic_play);
        }
    }

    public void stopPlaying() {
        if (this.player != null) {
            this.player.stop();
            this.player.reset();
            this.ib_play.setBackgroundResource(R.drawable.ic_play);
        }
    }

    public boolean isPlaying() {
        try {
            return this.player != null && this.player.isPlaying();
        }
        catch (Exception e) {
            return false;
        }
    }
}

