/*
 * Decompiled with CFR 0.152.
 */
package segmented_control.widget.custom.android.com.segmentedcontrol.utils;

import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.IntRange;
import segmented_control.widget.custom.android.com.segmentedcontrol.utils.ArgbEvaluator;

public class Utils {
    public static <T> T lazy(T nullable, T nonNull) {
        if (nullable == null) {
            nullable = nonNull;
        }
        return nullable;
    }

    public static int defineSegmentBackground(@IntRange(from=0L) int absolutePosition, @IntRange(from=1L) int columnCount, @IntRange(from=1L) int size) {
        if (size == 1) {
            return 0;
        }
        if (columnCount == 1) {
            if (absolutePosition == 0) {
                return 1;
            }
            if (absolutePosition == size - 1) {
                return 7;
            }
        }
        if (size <= columnCount) {
            if (absolutePosition == 0) {
                return 3;
            }
            if (absolutePosition == size - 1) {
                return 4;
            }
        }
        if (absolutePosition == 0) {
            return 2;
        }
        if (absolutePosition == columnCount - 1) {
            return 5;
        }
        int notCompletedRowItemsCount = size % columnCount;
        int completeRowsItemsCount = size - notCompletedRowItemsCount;
        if (notCompletedRowItemsCount == 1 && absolutePosition == completeRowsItemsCount) {
            return 7;
        }
        if (notCompletedRowItemsCount == 0) {
            if (absolutePosition == size - columnCount) {
                return 8;
            }
            if (absolutePosition == size - 1) {
                return 9;
            }
        } else if (notCompletedRowItemsCount > 0) {
            if (absolutePosition == size - notCompletedRowItemsCount) {
                return 8;
            }
            if (absolutePosition == size - 1) {
                return 9;
            }
        }
        return 6;
    }

    public static float[] defineRadiusForPosition(@IntRange(from=0L) int absolutePosition, @IntRange(from=1L) int columnCount, @IntRange(from=1L) int size, int topLeftRadius, int topRightRadius, int bottomRightRadius, int bottomLeftRadius) {
        int bgType = Utils.defineSegmentBackground(absolutePosition, columnCount, size);
        switch (bgType) {
            case 8: {
                return Utils.createRadius(0.0f, 0.0f, 0.0f, bottomLeftRadius);
            }
            case 9: {
                return Utils.createRadius(0.0f, 0.0f, bottomRightRadius, 0.0f);
            }
            case 7: {
                return Utils.createRadius(0.0f, 0.0f, bottomRightRadius, bottomLeftRadius);
            }
            case 6: {
                return Utils.createRadius(0.0f, 0.0f, 0.0f, 0.0f);
            }
            case 0: {
                return Utils.createRadius(topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius);
            }
            case 2: {
                return Utils.createRadius(topLeftRadius, 0.0f, 0.0f, 0.0f);
            }
            case 3: {
                return Utils.createRadius(topLeftRadius, 0.0f, 0.0f, bottomLeftRadius);
            }
            case 5: {
                return Utils.createRadius(0.0f, topRightRadius, 0.0f, 0.0f);
            }
            case 4: {
                return Utils.createRadius(0.0f, topRightRadius, bottomRightRadius, 0.0f);
            }
            case 1: {
                return Utils.createRadius(topLeftRadius, topRightRadius, 0.0f, 0.0f);
            }
        }
        return Utils.createRadius(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public static float[] createRadius(float topLeft, float topRight, float bottomRight, float bottomLeft) {
        return new float[]{topLeft, topLeft, topRight, topRight, bottomRight, bottomRight, bottomLeft, bottomLeft};
    }

    public static Drawable getBackground(int strokeWidth, int strokeColor, int argb, float[] radii) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setShape(0);
        drawable.setStroke(strokeWidth, strokeColor);
        drawable.setCornerRadii(radii);
        drawable.setColor(argb);
        return drawable;
    }

    public static ValueAnimator createBackgroundAnimation(int argbStart, int argbEnd) {
        return ValueAnimator.ofObject((TypeEvaluator)ArgbEvaluator.getInstance(), (Object[])new Object[]{argbStart, argbEnd});
    }

    public static boolean isInBounds(float touchX, float touchY, float viewX, float viewY, float viewW, float viewH) {
        return touchX >= viewX && touchX <= viewX + viewW && touchY >= viewY && touchY <= viewY + viewH;
    }
}

