/*
 * Decompiled with CFR 0.152.
 */
package segmented_control.widget.custom.android.com.segmentedcontrol.item_row_column;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;

public class SegmentDecoration {
    public static final int DEFAULT_FOCUSED_BACKGROUND_ALPHA = 36;
    public static final int DEFAULT_SELECTION_ANIMATION_DURATION = 196;
    @ColorInt
    public int selectedStrokeColor;
    @ColorInt
    public int unSelectedStrokeColor;
    public int strokeWidth;
    @ColorInt
    public int selectBackgroundColor;
    @ColorInt
    public int unSelectedBackgroundColor;
    public int focusedBackgroundColor;
    public int selectionAnimationDuration;
    @ColorInt
    public int selectedTextColor;
    @ColorInt
    public int unSelectedTextColor;
    public int textSize;
    public int textHorizontalPadding;
    public int textVerticalPadding;
    public int segmentVerticalMargin;
    public int segmentHorizontalMargin;
    public Typeface typeface;
    public int topLeftRadius;
    public int topRightRadius;
    public int bottomRightRadius;
    public int bottomLeftRadius;
    public boolean radiusForEverySegment = false;

    public static SegmentDecoration createDefault(Context context, int accentColor) {
        SegmentDecoration sd = new SegmentDecoration();
        sd.selectedStrokeColor = accentColor;
        sd.unSelectedStrokeColor = accentColor;
        sd.selectBackgroundColor = accentColor;
        sd.unSelectedBackgroundColor = ContextCompat.getColor((Context)context, (int)17170445);
        sd.focusedBackgroundColor = Color.argb((int)36, (int)Color.red((int)accentColor), (int)Color.green((int)accentColor), (int)Color.blue((int)accentColor));
        sd.selectionAnimationDuration = 196;
        sd.selectedTextColor = ContextCompat.getColor((Context)context, (int)17170443);
        sd.unSelectedTextColor = accentColor;
        sd.strokeWidth = 1;
        sd.typeface = null;
        return sd;
    }

    public int getSelectedStrokeColor() {
        return this.selectedStrokeColor;
    }

    public int getUnSelectedStrokeColor() {
        return this.unSelectedStrokeColor;
    }

    public int getStrokeWidth() {
        return this.strokeWidth;
    }

    public int getSelectBackgroundColor() {
        return this.selectBackgroundColor;
    }

    public int getUnSelectedBackgroundColor() {
        return this.unSelectedBackgroundColor;
    }

    public int getFocusedBackgroundColor() {
        return this.focusedBackgroundColor;
    }

    public int getSelectionAnimationDuration() {
        return this.selectionAnimationDuration;
    }

    public int getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public int getUnSelectedTextColor() {
        return this.unSelectedTextColor;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public int getTextHorizontalPadding() {
        return this.textHorizontalPadding;
    }

    public int getTextVerticalPadding() {
        return this.textVerticalPadding;
    }

    public int getSegmentVerticalMargin() {
        return this.segmentVerticalMargin;
    }

    public int getSegmentHorizontalMargin() {
        return this.segmentHorizontalMargin;
    }

    public int getTopLeftRadius() {
        return this.topLeftRadius;
    }

    public int getTopRightRadius() {
        return this.topRightRadius;
    }

    public int getBottomRightRadius() {
        return this.bottomRightRadius;
    }

    public int getBottomLeftRadius() {
        return this.bottomLeftRadius;
    }

    public boolean isRadiusForEverySegment() {
        return this.radiusForEverySegment;
    }

    public Typeface getTypeface() {
        return this.typeface;
    }
}

