/*
 * Decompiled with CFR 0.152.
 */
package segmented_control.widget.custom.android.com.segmentedcontrol;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import java.util.List;
import section_layout.widget.custom.android.com.sectionlayout.SectionLayout;
import segmented_control.widget.custom.android.com.segmented_control.R;
import segmented_control.widget.custom.android.com.segmentedcontrol.Assert;
import segmented_control.widget.custom.android.com.segmentedcontrol.Consumer;
import segmented_control.widget.custom.android.com.segmentedcontrol.SegmentConsumer;
import segmented_control.widget.custom.android.com.segmentedcontrol.SegmentedControlControllerComponent;
import segmented_control.widget.custom.android.com.segmentedcontrol.SegmentedControlViewComponent;
import segmented_control.widget.custom.android.com.segmentedcontrol.custom_segment.SegmentAdapterImpl;
import segmented_control.widget.custom.android.com.segmentedcontrol.item_row_column.SegmentAdapter;
import segmented_control.widget.custom.android.com.segmentedcontrol.item_row_column.SegmentViewHolder;
import segmented_control.widget.custom.android.com.segmentedcontrol.listeners.OnSegmentClickListener;
import segmented_control.widget.custom.android.com.segmentedcontrol.listeners.OnSegmentSelectRequestListener;
import segmented_control.widget.custom.android.com.segmentedcontrol.listeners.OnSegmentSelectedListener;
import view_component.lib_android.com.view_component.base_view.layouts.ComponentFrameLayout;

public class SegmentedControl<D>
extends ComponentFrameLayout<SegmentedControlViewComponent<D>, SegmentedControlControllerComponent<D>> {
    public SegmentedControl(Context context) {
        this(context, null);
    }

    public SegmentedControl(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SegmentedControl(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttr(attrs, defStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttr(AttributeSet attrs, int defStyle) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SegmentedControl, defStyle, 0);
        this.fetchAccentColor();
        try {
            this.attrDistributeEvenly(typedArray);
            this.attrReselectionEnabled(typedArray);
            this.attrColumnCount(typedArray);
            this.attrSupportedSelectionsCount(typedArray);
            this.attrSelectedStrokeColor(typedArray);
            this.attrUnSelectedStrokeColor(typedArray);
            this.attrStrokeWidth(typedArray);
            this.attrSelectedBackgroundColor(typedArray);
            this.attrFocusedBackgroundColor(typedArray);
            this.attrSelectionAnimationDuration(typedArray);
            this.attrUnSelectedBackgroundColor(typedArray);
            this.attrSelectedTextColor(typedArray);
            this.attrUnSelectedTextColor(typedArray);
            this.attrTextSize(typedArray);
            this.attrFontAssetPath(typedArray);
            this.attrTextVerticalPadding(typedArray);
            this.attrTextHorizontalPadding(typedArray);
            this.attrSegmentHorizontalMargin(typedArray);
            this.attrSegmentVerticalMargin(typedArray);
            this.attrTopLeftRadius(typedArray);
            this.attrTopRightRadius(typedArray);
            this.attrBottomRightRadius(typedArray);
            this.attrBottomLeftRadius(typedArray);
            this.attrRadius(typedArray);
            this.attrRadiusForEverySegment(typedArray);
            this.attrSegments(typedArray);
        }
        finally {
            typedArray.recycle();
        }
    }

    private void fetchAccentColor() {
        TypedValue tv = new TypedValue();
        TypedArray typedArray = this.getContext().obtainStyledAttributes(tv.data, new int[]{R.attr.colorAccent});
        try {
            ((SegmentedControlControllerComponent)this.getControllerComponent()).setAccentColor(typedArray.getColor(0, 0));
        }
        finally {
            typedArray.recycle();
        }
    }

    private void attrSelectedStrokeColor(TypedArray typedArray) {
        this.obtainColorAttr(typedArray, R.styleable.SegmentedControl_selectedStrokeColor, new Consumer<Integer>(){

            @Override
            public void apply(Integer color2) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setSelectedStrokeColor(color2);
            }
        });
    }

    private void attrUnSelectedStrokeColor(TypedArray typedArray) {
        this.obtainColorAttr(typedArray, R.styleable.SegmentedControl_unSelectedStrokeColor, new Consumer<Integer>(){

            @Override
            public void apply(Integer color2) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setUnSelectedStrokeColor(color2);
            }
        });
    }

    private void attrStrokeWidth(TypedArray typedArray) {
        this.obtainDimensionAttr(typedArray, R.styleable.SegmentedControl_strokeWidth, new Consumer<Integer>(){

            @Override
            public void apply(Integer width) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setStrokeWidth(width);
            }
        });
    }

    private void attrSelectedBackgroundColor(TypedArray typedArray) {
        this.obtainColorAttr(typedArray, R.styleable.SegmentedControl_selectedBackgroundColor, new Consumer<Integer>(){

            @Override
            public void apply(Integer color2) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setSelectedBackgroundColor(color2);
            }
        });
    }

    private void attrUnSelectedBackgroundColor(TypedArray typedArray) {
        this.obtainColorAttr(typedArray, R.styleable.SegmentedControl_unSelectedBackgroundColor, new Consumer<Integer>(){

            @Override
            public void apply(Integer color2) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setUnSelectedBackgroundColor(color2);
            }
        });
    }

    private void attrFocusedBackgroundColor(TypedArray typedArray) {
        this.obtainColorAttr(typedArray, R.styleable.SegmentedControl_focusedBackgroundColor, new Consumer<Integer>(){

            @Override
            public void apply(Integer color2) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setFocusedBackgroundColor(color2);
            }
        });
    }

    private void attrSelectionAnimationDuration(TypedArray typedArray) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setSelectionAnimationDuration(typedArray.getInt(R.styleable.SegmentedControl_selectionAnimationDuration, 196));
    }

    private void attrSelectedTextColor(TypedArray typedArray) {
        this.obtainColorAttr(typedArray, R.styleable.SegmentedControl_selectedTextColor, new Consumer<Integer>(){

            @Override
            public void apply(Integer color2) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setSelectedTextColor(color2);
            }
        });
    }

    private void attrUnSelectedTextColor(TypedArray typedArray) {
        this.obtainColorAttr(typedArray, R.styleable.SegmentedControl_unSelectedTextColor, new Consumer<Integer>(){

            @Override
            public void apply(Integer color2) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setUnSelectedTextColor(color2);
            }
        });
    }

    private void attrTextSize(TypedArray typedArray) {
        int textSize = typedArray.getDimensionPixelSize(R.styleable.SegmentedControl_textSize, (int)TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        if (textSize > 0) {
            ((SegmentedControlControllerComponent)this.getControllerComponent()).setTextSize(textSize);
        }
    }

    private void attrFontAssetPath(TypedArray typedArray) {
        String fontPath = typedArray.getString(R.styleable.SegmentedControl_fontAssetPath);
        if (fontPath != null && !fontPath.isEmpty()) {
            ((SegmentedControlControllerComponent)this.getControllerComponent()).setTypeFace(Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)fontPath));
        }
    }

    private void attrTextVerticalPadding(TypedArray typedArray) {
        this.obtainDimensionAttr(typedArray, R.styleable.SegmentedControl_textVerticalPadding, new Consumer<Integer>(){

            @Override
            public void apply(Integer dimen) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setTextVerticalPadding(dimen);
            }
        });
    }

    private void attrTextHorizontalPadding(TypedArray typedArray) {
        this.obtainDimensionAttr(typedArray, R.styleable.SegmentedControl_textHorizontalPadding, new Consumer<Integer>(){

            @Override
            public void apply(Integer dimen) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setTextHorizontalPadding(dimen);
            }
        });
    }

    private void attrSegmentVerticalMargin(TypedArray typedArray) {
        this.obtainDimensionAttr(typedArray, R.styleable.SegmentedControl_segmentVerticalMargin, new Consumer<Integer>(){

            @Override
            public void apply(Integer dimen) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setSegmentVerticalMargin(dimen);
            }
        });
    }

    private void attrSegmentHorizontalMargin(TypedArray typedArray) {
        this.obtainDimensionAttr(typedArray, R.styleable.SegmentedControl_segmentHorizontalMargin, new Consumer<Integer>(){

            @Override
            public void apply(Integer dimen) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setSegmentHorizontalMargin(dimen);
            }
        });
    }

    private void attrRadius(TypedArray typedArray) {
        this.obtainDimensionAttr(typedArray, R.styleable.SegmentedControl_radius, new Consumer<Integer>(){

            @Override
            public void apply(Integer dimen) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setRadius(dimen);
            }
        });
    }

    private void attrTopLeftRadius(TypedArray typedArray) {
        this.obtainDimensionAttr(typedArray, R.styleable.SegmentedControl_topLeftRadius, new Consumer<Integer>(){

            @Override
            public void apply(Integer dimen) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setTopLeftRadius(dimen);
            }
        });
    }

    private void attrTopRightRadius(TypedArray typedArray) {
        this.obtainDimensionAttr(typedArray, R.styleable.SegmentedControl_topRightRadius, new Consumer<Integer>(){

            @Override
            public void apply(Integer dimen) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setTopRightRadius(dimen);
            }
        });
    }

    private void attrBottomRightRadius(TypedArray typedArray) {
        this.obtainDimensionAttr(typedArray, R.styleable.SegmentedControl_bottomRightRadius, new Consumer<Integer>(){

            @Override
            public void apply(Integer dimen) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setBottomRightRadius(dimen);
            }
        });
    }

    private void attrBottomLeftRadius(TypedArray typedArray) {
        this.obtainDimensionAttr(typedArray, R.styleable.SegmentedControl_bottomLeftRadius, new Consumer<Integer>(){

            @Override
            public void apply(Integer dimen) {
                ((SegmentedControlControllerComponent)SegmentedControl.this.getControllerComponent()).setBottomLeftRadius(dimen);
            }
        });
    }

    private void attrRadiusForEverySegment(TypedArray typedArray) {
        boolean radiusForEverySegment = typedArray.getBoolean(R.styleable.SegmentedControl_radiusForEverySegment, false);
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setRadiusForEverySegment(radiusForEverySegment);
    }

    private void attrSegments(TypedArray typedArray) {
        CharSequence[] items = typedArray.getTextArray(R.styleable.SegmentedControl_segments);
        this.useDefaultAdapter();
        ((SegmentedControlControllerComponent)this.getControllerComponent()).addSegments((Object[])items);
    }

    private void attrColumnCount(TypedArray typedArray) {
        int columnCount = typedArray.getInteger(R.styleable.SegmentedControl_columnCount, 2);
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setColumnCount(columnCount);
        this.notifyConfigIsChanged();
    }

    private void attrSupportedSelectionsCount(TypedArray typedArray) {
        int supportedSelectionsCount = typedArray.getInteger(R.styleable.SegmentedControl_supportedSelectionsCount, 1);
        if (supportedSelectionsCount > 0) {
            ((SegmentedControlControllerComponent)this.getControllerComponent()).setSupportedSelectionsCount(supportedSelectionsCount);
        }
    }

    private void attrDistributeEvenly(TypedArray typedArray) {
        boolean willDistribute = typedArray.getBoolean(R.styleable.SegmentedControl_distributeEvenly, false);
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setDistributeEvenly(willDistribute);
        ((SegmentedControlControllerComponent)this.getControllerComponent()).notifyConfigIsChanged();
    }

    private void attrReselectionEnabled(TypedArray typedArray) {
        boolean reselectionEnabled = typedArray.getBoolean(R.styleable.SegmentedControl_reselectionEnabled, true);
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setReselectionEnabled(reselectionEnabled);
    }

    private void obtainColorAttr(TypedArray typedArray, int attr2, Consumer<Integer> colorConsumer) {
        int color2 = typedArray.getColor(attr2, -2);
        if (color2 != -2) {
            colorConsumer.apply(color2);
        }
    }

    private void obtainDimensionAttr(TypedArray typedArray, int attr2, Consumer<Integer> dimensionConsumer) {
        int dimensionPixelSize = typedArray.getDimensionPixelSize(attr2, -1);
        if (dimensionPixelSize != -1) {
            dimensionConsumer.apply(dimensionPixelSize);
        }
    }

    @NonNull
    public SegmentedControlViewComponent<D> createViewComponent(@NonNull LayoutInflater layoutInflater) {
        this.addView((View)new SectionLayout(this.getContext()), 0);
        return new SegmentedControlViewComponent((View)this);
    }

    @NonNull
    public SegmentedControlControllerComponent<D> createControllerComponent() {
        return new SegmentedControlControllerComponent();
    }

    public void setSupportedSelectionsCount(int supportedSelectionsCount) {
        Assert.supportedSelectionsCount(supportedSelectionsCount);
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setSupportedSelectionsCount(supportedSelectionsCount);
    }

    public void setColumnCount(int columnCount) {
        Assert.columnCount(columnCount);
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setColumnCount(columnCount);
    }

    public void setAdapter(@NonNull SegmentAdapter adapter) {
        Assert.adapter(adapter);
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setAdapter(adapter);
    }

    public void useDefaultAdapter() {
        this.setAdapter(new SegmentAdapterImpl());
    }

    public void addSegments(D[] segmentData) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).addSegments(segmentData);
    }

    public void addSegments(List<D> segmentData) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).addSegments(segmentData);
    }

    public void setDistributeEvenly(boolean willDistributeEvenly) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setDistributeEvenly(willDistributeEvenly);
    }

    public void setReselectionEnabled(boolean isEnabled) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setReselectionEnabled(isEnabled);
    }

    public void addOnSegmentClickListener(OnSegmentClickListener<D> onSegmentClickListener) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).addOnSegmentClickListener(onSegmentClickListener);
    }

    public void removeOnSegmentClickListener(OnSegmentClickListener<D> onSegmentClickListener) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).removeOnSegmentClickListener(onSegmentClickListener);
    }

    public void addOnSegmentSelectListener(OnSegmentSelectedListener<D> onSegmentSelectedListener) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).addOnSegmentSelectListener(onSegmentSelectedListener);
    }

    public void removeOnSegmentSelectListener(OnSegmentSelectedListener<D> onSegmentSelectedListener) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).removeOnSegmentSelectListener(onSegmentSelectedListener);
    }

    public void setOnSegmentSelectRequestListener(OnSegmentSelectRequestListener<D> onSegmentSelectRequestListener) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setOnSegmentSelectRequestListener(onSegmentSelectRequestListener);
    }

    public void removeAllSegments() {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).removeAllSegments();
    }

    public SegmentViewHolder<D> findSegmentByAbsolutePosition(int position) {
        Assert.outOfBounds(position, this.size(), "SegmentedControl#findSegmentByAbsolutePosition");
        return ((SegmentedControlControllerComponent)this.getControllerComponent()).findSegmentByAbsolutePosition(position);
    }

    public SegmentViewHolder<D> findSegmentByColumnAndRow(int column, int row) {
        Assert.outOfBounds(((SegmentedControlControllerComponent)this.getControllerComponent()).getAbsolutePosition(column, row), this.size(), "SegmentedControl#setSelectedSegment");
        return ((SegmentedControlControllerComponent)this.getControllerComponent()).findSegmentByColumnAndRow(column, row);
    }

    public void setSelectedSegment(int position) {
        Assert.outOfBounds(position, this.size(), "SegmentedControl#setSelectedSegment");
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setSelectedSegment(position);
    }

    public void setSelectedSegment(int column, int row) {
        Assert.outOfBounds(((SegmentedControlControllerComponent)this.getControllerComponent()).getAbsolutePosition(column, row), this.size(), "SegmentedControl#setSelectedSegment");
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setSelectedSegment(column, row);
    }

    public void forEachSegment(SegmentConsumer<D> segmentConsumer) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).forEachSegment(segmentConsumer);
    }

    public void setSelectedStrokeColor(int color2) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setSelectedStrokeColor(color2);
    }

    public void setUnSelectedStrokeColor(int color2) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setUnSelectedStrokeColor(color2);
    }

    public void setFocusedBackgroundColor(int color2) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setFocusedBackgroundColor(color2);
    }

    public void setSelectionAnimationDuration(int duration) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setSelectionAnimationDuration(duration);
    }

    public void setStrokeWidth(int width) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setStrokeWidth(width);
    }

    public void setSelectedBackgroundColor(int color2) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setSelectedBackgroundColor(color2);
    }

    public void setUnSelectedBackgroundColor(int color2) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setUnSelectedBackgroundColor(color2);
    }

    public void setSelectedTextColor(int color2) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setSelectedTextColor(color2);
    }

    public void setUnSelectedTextColor(int color2) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setUnSelectedTextColor(color2);
    }

    public void setTextSize(int textSize) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setTextSize(textSize);
    }

    public void setTypeFace(Typeface typeFace) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setTypeFace(typeFace);
    }

    public void setTextVerticalPadding(int padding) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setTextVerticalPadding(padding);
    }

    public void setTextHorizontalPadding(int padding) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setTextHorizontalPadding(padding);
    }

    public void setSegmentVerticalMargin(int margin) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setSegmentVerticalMargin(margin);
    }

    public void setSegmentHorizontalMargin(int margin) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setSegmentHorizontalMargin(margin);
    }

    public void setRadius(int radius) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setRadius(radius);
    }

    public void setTopLeftRadius(int radius) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setTopLeftRadius(radius);
    }

    public void setTopRightRadius(int radius) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setTopRightRadius(radius);
    }

    public void setBottomRightRadius(int radius) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setBottomRightRadius(radius);
    }

    public void setBottomLeftRadius(int radius) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setBottomLeftRadius(radius);
    }

    public void setRadiusForEverySegment(boolean radiusForEverySegment) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).setRadiusForEverySegment(radiusForEverySegment);
    }

    public void clearSelection() {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).clearSelection(false);
    }

    public void clearSelection(boolean notifySegmentSelectedListener) {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).clearSelection(notifySegmentSelectedListener);
    }

    public void notifyConfigIsChanged() {
        ((SegmentedControlControllerComponent)this.getControllerComponent()).notifyConfigIsChanged();
    }

    public int size() {
        return ((SegmentedControlControllerComponent)this.getControllerComponent()).size();
    }

    public int[] getLastSelectedColumnAndRow() {
        return ((SegmentedControlControllerComponent)this.getControllerComponent()).getLastSelectedColumnAndRow();
    }

    public int getLastSelectedAbsolutePosition() {
        return ((SegmentedControlControllerComponent)this.getControllerComponent()).getLastSelectedAbsolutePosition();
    }

    public boolean hasSelectedSegment() {
        return ((SegmentedControlControllerComponent)this.getControllerComponent()).isSelected();
    }
}

