/*
 * Decompiled with CFR 0.152.
 */
package section_layout.widget.custom.android.com.sectionlayout;

import android.content.Context;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import java.util.LinkedList;
import section_layout.widget.custom.android.com.sectionlayout.Notifier;
import section_layout.widget.custom.android.com.sectionlayout.SectionLayout;
import section_layout.widget.custom.android.com.sectionlayout.SectionLayoutViewComponent;
import section_layout.widget.custom.android.com.sectionlayout.SectionManager;
import section_layout.widget.custom.android.com.sectionlayout.listeners.OnAddSectionListener;
import section_layout.widget.custom.android.com.sectionlayout.listeners.OnAddSectionRequestListener;
import section_layout.widget.custom.android.com.sectionlayout.listeners.OnAllSectionsRemoveRequestListener;
import section_layout.widget.custom.android.com.sectionlayout.listeners.OnAllSectionsRemovedListener;
import section_layout.widget.custom.android.com.sectionlayout.listeners.OnRemoveSectionListener;
import section_layout.widget.custom.android.com.sectionlayout.listeners.OnRemoveSectionRequestListener;
import view_component.lib_android.com.view_component.base_view.ControllerComponent;
import view_component.lib_android.com.view_component.base_view.ViewComponent;
import view_component.lib_android.com.view_component.base_view.functional_interfaces.Request;

public class SectionLayoutViewControllerComponent<D>
extends ControllerComponent<SectionLayoutViewComponent>
implements SectionManager<D> {
    private final LinkedList<SectionLayout.ViewHolder<D>> viewHolders = new LinkedList();
    private SectionLayout.Adapter adapter;
    private final Notifier<D> notifier = new Notifier();

    public void onCreate(@NonNull SectionLayoutViewComponent viewComponent) {
        super.onCreate((ViewComponent)viewComponent);
    }

    SectionLayoutViewControllerComponent<D> withAdapter(@NonNull SectionLayout.Adapter adapter) {
        this.adapter = adapter;
        return this;
    }

    @Override
    public SectionManager<D> addSection(@Nullable D sectionData) {
        this.insertSectionAtPosition(sectionData, this.nextAvailablePosition());
        return this;
    }

    @Override
    public SectionManager<D> addNullableSection() {
        return this.addSection(null);
    }

    @Override
    public SectionManager<D> insertSectionAtPosition(final @Nullable D sectionData, final @IntRange(from=0L) int sectionPosition) {
        if (this.notifier.onAddSectionRequest(sectionData, sectionPosition)) {
            this.requestHolderComponent((Request)new Request<SectionLayoutViewComponent>(){

                public void onResult(@NonNull SectionLayoutViewComponent sectionLayoutViewComponent) {
                    SectionLayoutViewControllerComponent.this.assertNullAdapter();
                    SectionLayoutViewControllerComponent.this.assertWrongInsertPosition(sectionPosition);
                    Object vh = SectionLayoutViewControllerComponent.this.adapter.onCreateViewHolder(LayoutInflater.from((Context)SectionLayoutViewControllerComponent.this.getContext()), ((SectionLayoutViewComponent)SectionLayoutViewControllerComponent.this.getViewComponent()).getRootViewGroup(), SectionLayoutViewControllerComponent.this.adapter.getViewType(sectionData, sectionPosition));
                    ((SectionLayout.ViewHolder)vh).setSectionPosition(sectionPosition);
                    SectionLayoutViewControllerComponent.this.adapter.onBindViewHolder(vh, sectionData, sectionPosition);
                    SectionLayoutViewControllerComponent.this.viewHolders.add(sectionPosition, vh);
                    sectionLayoutViewComponent.getRootViewGroup().addView(((SectionLayout.ViewHolder)vh).getSectionView(), sectionPosition);
                    SectionLayoutViewControllerComponent.this.syncPositions(sectionPosition + 1);
                    SectionLayoutViewControllerComponent.this.notifier.onSectionAdded(sectionData, sectionPosition);
                }
            });
        }
        this.logViewHolders();
        return this;
    }

    @Override
    public SectionManager<D> removeFirstSectionWithData(D sectionData) {
        this.removeSection(sectionData, true);
        this.logViewHolders();
        return this;
    }

    @Override
    public SectionManager<D> removeAllSectionsWithData(D sectionData) {
        this.removeSection(sectionData, false);
        this.logViewHolders();
        return this;
    }

    @Override
    public SectionManager<D> removeLastSection() {
        final int index = this.size() - 1;
        this.assertIndexOutOfBounds(index, "SectionManager#removeLastSection");
        this.requestHolderComponent((Request)new Request<SectionLayoutViewComponent>(){

            public void onResult(@NonNull SectionLayoutViewComponent sectionLayoutViewComponent) {
                if (SectionLayoutViewControllerComponent.this.notifier.onRemoveSectionRequest(((SectionLayout.ViewHolder)SectionLayoutViewControllerComponent.this.viewHolders.getLast()).getSectionData())) {
                    sectionLayoutViewComponent.getRootViewGroup().removeViewAt(index);
                    SectionLayoutViewControllerComponent.this.viewHolders.removeLast();
                    SectionLayoutViewControllerComponent.this.notifier.onSectionRemoved(index);
                }
            }
        });
        this.logViewHolders();
        return this;
    }

    @Override
    public SectionManager<D> removeFirstSection() {
        this.assertIndexOutOfBounds(0, "SectionManager#removeFirstSection");
        this.requestHolderComponent((Request)new Request<SectionLayoutViewComponent>(){

            public void onResult(@NonNull SectionLayoutViewComponent sectionLayoutViewComponent) {
                if (SectionLayoutViewControllerComponent.this.notifier.onRemoveSectionRequest(((SectionLayout.ViewHolder)SectionLayoutViewControllerComponent.this.viewHolders.getFirst()).getSectionData())) {
                    sectionLayoutViewComponent.getRootViewGroup().removeViewAt(0);
                    SectionLayoutViewControllerComponent.this.viewHolders.removeFirst();
                    SectionLayoutViewControllerComponent.this.syncPositions(0);
                    SectionLayoutViewControllerComponent.this.notifier.onSectionRemoved(0);
                }
            }
        });
        this.logViewHolders();
        return this;
    }

    @Override
    public SectionManager<D> removeSectionAtPosition(@IntRange(from=0L) int sectionPosition) {
        this.assertIndexOutOfBounds(sectionPosition, "SectionManager#removeSectionAtPosition");
        this.removeSection(sectionPosition);
        return this;
    }

    @Override
    public SectionManager<D> removeAllSections() {
        this.requestHolderComponent((Request)new Request<SectionLayoutViewComponent>(){

            public void onResult(@NonNull SectionLayoutViewComponent sectionLayoutViewComponent) {
                if (SectionLayoutViewControllerComponent.this.notifier.onAllSectionsRemoveRequest()) {
                    sectionLayoutViewComponent.getRootViewGroup().removeAllViews();
                    SectionLayoutViewControllerComponent.this.viewHolders.clear();
                    SectionLayoutViewControllerComponent.this.notifier.onAllSectionsRemoved();
                }
            }
        });
        this.logViewHolders();
        return this;
    }

    int size() {
        return this.viewHolders.size();
    }

    SectionLayout.ViewHolder<D> getViewHolderForAdapterPosition(int adapterPosition) {
        this.assertIndexOutOfBounds(adapterPosition, "SectionLayoutViewControllerComponent#getViewHolderForAdapterPosition");
        return this.viewHolders.get(adapterPosition);
    }

    @Nullable
    SectionLayout.ViewHolder<D> getFirstViewHolderWithData(D sectionData) {
        if (sectionData != null) {
            for (int i = 0; i < this.viewHolders.size(); ++i) {
                SectionLayout.ViewHolder<D> viewHolder = this.viewHolders.get(i);
                if (!sectionData.equals(viewHolder.getSectionData())) continue;
                return viewHolder;
            }
        }
        return null;
    }

    private void removeSection(final D sectionData, final boolean removeFirst) {
        this.requestHolderComponent((Request)new Request<SectionLayoutViewComponent>(){

            public void onResult(@NonNull SectionLayoutViewComponent sectionLayoutViewComponent) {
                if (sectionData != null) {
                    for (int i = 0; i < SectionLayoutViewControllerComponent.this.viewHolders.size(); ++i) {
                        SectionLayout.ViewHolder holder = (SectionLayout.ViewHolder)SectionLayoutViewControllerComponent.this.viewHolders.get(i);
                        if (!sectionData.equals(holder.getSectionData())) continue;
                        boolean isRemoved = SectionLayoutViewControllerComponent.this.removeSection(i);
                        if (removeFirst) break;
                        if (!isRemoved) continue;
                        --i;
                    }
                }
            }
        });
    }

    private boolean removeSection(int sectionPosition) {
        if (this.getViewComponent() != null && this.notifier.onRemoveSectionRequest(this.viewHolders.get(sectionPosition).getSectionData())) {
            ((SectionLayoutViewComponent)this.getViewComponent()).getRootViewGroup().removeViewAt(sectionPosition);
            this.viewHolders.remove(sectionPosition);
            this.syncPositions(sectionPosition);
            this.notifier.onSectionRemoved(sectionPosition);
            return true;
        }
        this.logViewHolders();
        return false;
    }

    private int nextAvailablePosition() {
        return this.getViewComponent() != null ? ((SectionLayoutViewComponent)this.getViewComponent()).getRootViewGroup().getChildCount() : 0;
    }

    private void syncPositions(int from) {
        for (int i = from; i < this.viewHolders.size(); ++i) {
            SectionLayout.ViewHolder<D> holder = this.viewHolders.get(i);
            holder.setSectionPosition(i);
        }
    }

    private void logViewHolders() {
    }

    private void assertWrongInsertPosition(int position) {
        if (position > this.viewHolders.size() || position < 0) {
            throw new IndexOutOfBoundsException("SectionManager#insertSectionAtPosition() -> Out of bounds, invalid sectionPosition value, sectionPosition = " + position + ", size() = " + this.size());
        }
    }

    private void assertIndexOutOfBounds(int position, String methodName) {
        if (position >= this.viewHolders.size() || position < 0) {
            throw new IndexOutOfBoundsException(methodName + " -> Out of bounds, invalid sectionPosition value, sectionPosition = " + position + ", size() = " + this.size());
        }
    }

    private void assertNullAdapter() {
        if (this.adapter == null) {
            throw new RuntimeException("Section can't be added with null adapter, at first call SectionManager::withAdapter method, and pass non null adapter");
        }
    }

    void setOnAddSectionListener(OnAddSectionListener<D> onAddSectionListener) {
        this.notifier.setOnAddSectionListener(onAddSectionListener);
    }

    void setOnRemoveSectionListener(OnRemoveSectionListener onRemoveSectionListener) {
        this.notifier.setOnRemoveSectionListener(onRemoveSectionListener);
    }

    void setOnAddSectionRequestListener(OnAddSectionRequestListener<D> onAddSectionRequestListener) {
        this.notifier.setOnAddSectionRequestListener(onAddSectionRequestListener);
    }

    void setOnRemoveSectionRequestListener(OnRemoveSectionRequestListener<D> onRemoveSectionRequestListener) {
        this.notifier.setOnRemoveSectionRequestListener(onRemoveSectionRequestListener);
    }

    void setOnAllSectionsRemovedListener(OnAllSectionsRemovedListener onAllSectionsRemovedListener) {
        this.notifier.setOnAllSectionsRemovedListener(onAllSectionsRemovedListener);
    }

    void setOnAllSectionsRemoveRequestListener(OnAllSectionsRemoveRequestListener onAllSectionsRemoveRequestListener) {
        this.notifier.setOnAllSectionsRemoveRequestListener(onAllSectionsRemoveRequestListener);
    }

    OnAddSectionListener<D> getOnAddSectionListener() {
        return this.notifier.getOnAddSectionListener();
    }

    OnRemoveSectionListener getOnRemoveSectionListener() {
        return this.notifier.getOnRemoveSectionListener();
    }

    OnAddSectionRequestListener<D> getOnAddSectionRequestListener() {
        return this.notifier.getOnAddSectionRequestListener();
    }

    OnRemoveSectionRequestListener<D> getOnRemoveSectionRequestListener() {
        return this.notifier.getOnRemoveSectionRequestListener();
    }

    OnAllSectionsRemovedListener getOnAllSectionsRemovedListener() {
        return this.notifier.getOnAllSectionsRemovedListener();
    }

    OnAllSectionsRemoveRequestListener getOnAllSectionsRemoveRequestListener() {
        return this.notifier.getOnAllSectionsRemoveRequestListener();
    }
}

