/*
 * Decompiled with CFR 0.152.
 */
package com.ritaja.xchangerate.storage;

import com.ritaja.xchangerate.storage.DiskStore;
import com.ritaja.xchangerate.storage.StorageException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class FileStore
extends DiskStore {
    protected String resourceFilepath = System.getProperty("java.io.tmpdir");
    protected String ratesFilename;

    public FileStore(String filenameAppender) {
        this.ratesFilename = System.getProperty("file.separator") + filenameAppender + "XchangeRates.json";
    }

    public void setResourceFilepath(String resourceFilepath) {
        this.resourceFilepath = resourceFilepath;
    }

    public void saveRates(JSONObject exchangeRates) throws StorageException {
        if (exchangeRates == null) {
            throw new StorageException("Cannot save null exchangeRates!");
        }
        try {
            FileWriter file = new FileWriter(this.resourceFilepath + this.ratesFilename);
            file.write(exchangeRates.toString());
            file.flush();
            file.close();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    public JSONObject loadRates() throws StorageException {
        String jsonData = "";
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.resourceFilepath + this.ratesFilename));
            while ((line = br.readLine()) != null) {
                jsonData = jsonData + line + "\n";
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        try {
            return new JSONObject(jsonData);
        }
        catch (JSONException e) {
            throw new StorageException(e);
        }
    }

    public boolean resourceExists() {
        File f = new File(this.resourceFilepath + this.ratesFilename);
        return f.exists() && !f.isDirectory();
    }
}

