/*
 * Decompiled with CFR 0.152.
 */
package com.ritaja.xchangerate.endpoint;

import com.ritaja.xchangerate.api.CurrencyNotSupportedException;
import com.ritaja.xchangerate.endpoint.EndpointException;
import com.ritaja.xchangerate.endpoint.EndpointFactory;
import com.ritaja.xchangerate.storage.DiskStore;
import com.ritaja.xchangerate.util.Currency;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class YahooEndpoint
extends EndpointFactory {
    public static final String BASE_URL = "http://finance.yahoo.com/webservice/v1/symbols/allcurrencies/";
    public static final String ENDPOINT = "quote";
    private Map rate = new HashMap();

    public YahooEndpoint(DiskStore diskStore) {
        super(diskStore, Currency.USD, "http://finance.yahoo.com/webservice/v1/symbols/allcurrencies/quote?format=json");
    }

    public boolean checkResponse() throws EndpointException, JSONException {
        this.response.getJSONObject("list").getJSONArray("resources").getJSONObject(1).getJSONObject("resource").getJSONObject("fields").getString("name");
        return true;
    }

    public BigDecimal getRate(Currency currency) throws JSONException, CurrencyNotSupportedException {
        if (!this.rate.isEmpty() && this.rate.containsKey((Object)currency)) {
            return (BigDecimal)this.rate.get((Object)currency);
        }
        JSONArray resources = this.exchangeRates.getJSONObject("list").getJSONArray("resources");
        for (int i = 0; i < resources.length(); ++i) {
            JSONObject field = resources.getJSONObject(i).getJSONObject("resource").getJSONObject("fields");
            if (!field.getString("name").equalsIgnoreCase("USD/" + currency.toString())) continue;
            this.rate.put(currency, new BigDecimal(field.getDouble("price")));
            return new BigDecimal(field.getDouble("price"));
        }
        throw new CurrencyNotSupportedException("currency: " + (Object)((Object)currency) + " is not supported by Yahoo endpoint");
    }

    public long getTimestamp(Currency currency) throws JSONException, CurrencyNotSupportedException {
        if (currency.toString().equalsIgnoreCase(Currency.USD.toString())) {
            return new DateTime().getMillis();
        }
        return this.retrieveTimeForCurrency(currency);
    }

    private long retrieveTimeForCurrency(Currency currency) throws JSONException, CurrencyNotSupportedException {
        JSONArray resources = this.exchangeRates.getJSONObject("list").getJSONArray("resources");
        for (int i = 0; i < resources.length(); ++i) {
            JSONObject field = resources.getJSONObject(i).getJSONObject("resource").getJSONObject("fields");
            if (!field.getString("name").equalsIgnoreCase("USD/" + currency.toString())) continue;
            this.rate.put(currency, new BigDecimal(field.getString("price")));
            return Long.parseLong(field.getString("ts"), 10) * 1000L;
        }
        throw new CurrencyNotSupportedException("currency: " + (Object)((Object)currency) + " is not supported by Yahoo endpoint");
    }
}

