/*
 * Decompiled with CFR 0.152.
 */
package com.ritaja.xchangerate.endpoint;

import com.ritaja.xchangerate.api.CurrencyNotSupportedException;
import com.ritaja.xchangerate.caching.CachingXchangeRate;
import com.ritaja.xchangerate.endpoint.EndpointException;
import com.ritaja.xchangerate.endpoint.ServiceEndpoint;
import com.ritaja.xchangerate.service.HttpMethods;
import com.ritaja.xchangerate.service.HttpserviceImpl;
import com.ritaja.xchangerate.service.ServiceException;
import com.ritaja.xchangerate.storage.DiskStore;
import com.ritaja.xchangerate.util.Currency;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class EndpointFactory
extends CachingXchangeRate
implements ServiceEndpoint {
    public Currency baseCurrency;
    private HttpserviceImpl httpservice;
    protected JSONObject response;

    public EndpointFactory(DiskStore diskStore, Currency baseCurrency, String uri) {
        super(diskStore);
        this.baseCurrency = baseCurrency;
        this.httpservice = new HttpserviceImpl(uri);
    }

    public JSONObject sendLiveRequest() throws JSONException, ServiceException, EndpointException {
        this.response = this.httpservice.getResponse(HttpMethods.GET);
        if (this.checkResponse()) {
            return this.response;
        }
        return null;
    }

    public BigDecimal convertToBaseCurrency(BigDecimal moneyAmount, Currency fromCurrency) throws JSONException, CurrencyNotSupportedException {
        return moneyAmount.divide(this.getRate(fromCurrency), 2, RoundingMode.HALF_UP);
    }

    public BigDecimal convertFromBaseCurrency(BigDecimal moneyAmount, Currency toCurrency) throws JSONException, CurrencyNotSupportedException {
        int digitsBeforeDecimal = moneyAmount.toPlainString().split("\\.")[0].length();
        return this.getRate(toCurrency).multiply(moneyAmount, new MathContext(digitsBeforeDecimal + 2, RoundingMode.HALF_UP));
    }

    public abstract boolean checkResponse() throws EndpointException, JSONException;

    public abstract BigDecimal getRate(Currency var1) throws JSONException, CurrencyNotSupportedException;
}

