/*
 * Decompiled with CFR 0.152.
 */
package com.ritaja.xchangerate.endpoint;

import com.ritaja.xchangerate.endpoint.EndpointException;
import com.ritaja.xchangerate.endpoint.EndpointFactory;
import com.ritaja.xchangerate.storage.DiskStore;
import com.ritaja.xchangerate.util.Currency;
import java.math.BigDecimal;
import java.util.logging.Logger;
import org.json.JSONException;

public class CurrencyLayerEndpoint
extends EndpointFactory {
    public static final String BASE_URL = "http://apilayer.net/api/";
    public static final String ENDPOINT = "live";
    private static final Logger LOGGER = Logger.getLogger(CurrencyLayerEndpoint.class.getName());

    public CurrencyLayerEndpoint(DiskStore diskStore, String accessKey) {
        super(diskStore, Currency.USD, "http://apilayer.net/api/live?access_key=" + accessKey);
    }

    public BigDecimal getRate(Currency currency) throws JSONException {
        return new BigDecimal(this.exchangeRates.getJSONObject("quotes").getDouble("USD" + (Object)((Object)currency)));
    }

    public boolean checkResponse() throws EndpointException, JSONException {
        if (this.response.get("success").toString().equalsIgnoreCase("false")) {
            throw new EndpointException("Currency Layer request did not succeed, info: " + this.response.getJSONObject("error").get("info"));
        }
        return true;
    }

    public long getTimestamp(Currency currency) throws JSONException {
        return Long.parseLong(this.exchangeRates.get("timestamp").toString(), 10) * 1000L;
    }
}

