/*
 * Decompiled with CFR 0.152.
 */
package com.ritaja.xchangerate.caching;

import com.ritaja.xchangerate.api.CurrencyNotSupportedException;
import com.ritaja.xchangerate.storage.DiskStore;
import com.ritaja.xchangerate.storage.StorageException;
import com.ritaja.xchangerate.util.Currency;
import org.joda.time.DateTime;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class CachingXchangeRate {
    public int refreshRateSeconds = 86400;
    public JSONObject exchangeRates = null;
    private DiskStore diskStore;

    public CachingXchangeRate(DiskStore diskStore) {
        this.diskStore = diskStore;
    }

    public void setExchangeRates(JSONObject exchangeRates) {
        this.exchangeRates = exchangeRates;
    }

    public boolean checkRatesUsable(Currency currency) throws JSONException, CurrencyNotSupportedException, StorageException {
        long now;
        long old;
        if (!this.diskStore.resourceExists()) {
            return false;
        }
        if (this.exchangeRates == null) {
            this.setExchangeRates(this.diskStore.loadRates());
        }
        return Math.abs(((old = this.getTimestamp(currency)) - (now = new DateTime().getMillis())) / 1000L) < (long)this.refreshRateSeconds;
    }

    public abstract long getTimestamp(Currency var1) throws JSONException, CurrencyNotSupportedException;
}

