/*
 * Decompiled with CFR 0.152.
 */
package com.ritaja.xchangerate.api;

import com.ritaja.xchangerate.api.CurrencyConverter;
import com.ritaja.xchangerate.endpoint.CurrencyLayerEndpoint;
import com.ritaja.xchangerate.endpoint.YahooEndpoint;
import com.ritaja.xchangerate.storage.DiskStore;
import com.ritaja.xchangerate.storage.FileStore;
import com.ritaja.xchangerate.util.Strategy;

public class CurrencyConverterBuilder {
    private String _accessKey;
    private Strategy _strategy;
    private DiskStore diskStore;

    public CurrencyConverter buildConverter() {
        if (this._strategy == null) {
            throw new IllegalArgumentException("No Strategy defined to create Currency converter");
        }
        if (this._strategy.equals((Object)Strategy.YAHOO_FINANCE_FILESTORE)) {
            this.diskStore = new FileStore("yahoo");
            return new CurrencyConverter(this.diskStore, new YahooEndpoint(this.diskStore));
        }
        if (this._strategy.equals((Object)Strategy.CURRENCY_LAYER_FILESTORE) && this._accessKey != null) {
            this.diskStore = new FileStore("currencyLayer");
            return new CurrencyConverter(this.diskStore, new CurrencyLayerEndpoint(this.diskStore, this._accessKey));
        }
        throw new IllegalArgumentException("Strategy: " + (Object)((Object)this._strategy) + " requires accessKey for endpoint service, none provided!");
    }

    public CurrencyConverterBuilder strategy(Strategy _strategy) {
        this._strategy = _strategy;
        return this;
    }

    public CurrencyConverterBuilder accessKey(String _accessKey) {
        this._accessKey = _accessKey;
        return this;
    }
}

