/*
 * Decompiled with CFR 0.152.
 */
package com.ritaja.xchangerate.api;

import com.ritaja.xchangerate.api.Converter;
import com.ritaja.xchangerate.api.CurrencyNotSupportedException;
import com.ritaja.xchangerate.endpoint.EndpointException;
import com.ritaja.xchangerate.endpoint.EndpointFactory;
import com.ritaja.xchangerate.service.ServiceException;
import com.ritaja.xchangerate.storage.DiskStore;
import com.ritaja.xchangerate.storage.StorageException;
import com.ritaja.xchangerate.util.Currency;
import java.math.BigDecimal;
import org.json.JSONException;
import org.json.JSONObject;

public class CurrencyConverter
implements Converter {
    public DiskStore diskStore;
    public EndpointFactory endpointFactory;

    public CurrencyConverter(DiskStore diskStore, EndpointFactory endpointFactory) {
        this.diskStore = diskStore;
        this.endpointFactory = endpointFactory;
    }

    public void setRefreshRateSeconds(int seconds) {
        this.endpointFactory.refreshRateSeconds = seconds;
    }

    public BigDecimal convertCurrency(BigDecimal moneyAmount, Currency fromCurrency, Currency toCurrency) throws CurrencyNotSupportedException, JSONException, StorageException, EndpointException, ServiceException {
        BigDecimal amount;
        this.updateResource(fromCurrency, toCurrency);
        if (fromCurrency == null || toCurrency == null) {
            throw new IllegalArgumentException("Convert currency takes 2 arguments!");
        }
        if (fromCurrency.equals((Object)toCurrency)) {
            amount = moneyAmount;
        } else if (fromCurrency.equals((Object)this.endpointFactory.baseCurrency)) {
            amount = this.endpointFactory.convertFromBaseCurrency(moneyAmount, toCurrency);
        } else if (toCurrency.equals((Object)this.endpointFactory.baseCurrency)) {
            amount = this.endpointFactory.convertToBaseCurrency(moneyAmount, fromCurrency);
        } else {
            BigDecimal intermediateAmount = this.endpointFactory.convertToBaseCurrency(moneyAmount, fromCurrency);
            amount = this.endpointFactory.convertFromBaseCurrency(intermediateAmount, toCurrency);
        }
        return amount;
    }

    public void updateResource(Currency fromCurrency, Currency toCurrency) throws CurrencyNotSupportedException, StorageException, JSONException, EndpointException, ServiceException {
        if (!this.endpointFactory.checkRatesUsable(fromCurrency) || !this.endpointFactory.checkRatesUsable(toCurrency)) {
            JSONObject response = this.endpointFactory.sendLiveRequest();
            this.diskStore.saveRates(response);
            this.endpointFactory.setExchangeRates(response);
        } else {
            this.endpointFactory.setExchangeRates(this.diskStore.loadRates());
        }
    }
}

