/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.core.trace;

import com.github.mkopylec.charon.configuration.CharonProperties;
import com.github.mkopylec.charon.core.trace.ForwardRequest;
import com.github.mkopylec.charon.core.trace.IncomingRequest;
import com.github.mkopylec.charon.core.trace.ReceivedResponse;
import com.github.mkopylec.charon.core.trace.TraceInterceptor;
import java.util.UUID;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class ProxyingTraceInterceptor {
    protected final CharonProperties charon;
    protected final TraceInterceptor traceInterceptor;

    public ProxyingTraceInterceptor(CharonProperties charon, TraceInterceptor traceInterceptor) {
        this.charon = charon;
        this.traceInterceptor = traceInterceptor;
    }

    public String generateTraceId() {
        return this.charon.getTracing().isEnabled() ? UUID.randomUUID().toString() : null;
    }

    public void onRequestReceived(String traceId, HttpMethod method, String uri, HttpHeaders headers) {
        this.runIfTracingIsEnabled(() -> {
            IncomingRequest request = new IncomingRequest();
            request.setMethod(method);
            request.setUri(uri);
            request.setHeaders(headers);
            this.traceInterceptor.onRequestReceived(traceId, request);
        });
    }

    public void onNoMappingFound(String traceId, HttpMethod method, String uri, HttpHeaders headers) {
        this.runIfTracingIsEnabled(() -> {
            IncomingRequest request = new IncomingRequest();
            request.setMethod(method);
            request.setUri(uri);
            request.setHeaders(headers);
            this.traceInterceptor.onNoMappingFound(traceId, request);
        });
    }

    public void onForwardStart(String traceId, String mappingName, HttpMethod method, String uri, byte[] body, HttpHeaders headers) {
        this.runIfTracingIsEnabled(() -> {
            ForwardRequest request = new ForwardRequest();
            request.setMappingName(mappingName);
            request.setMethod(method);
            request.setUri(uri);
            request.setBody(body);
            request.setHeaders(headers);
            this.traceInterceptor.onForwardStart(traceId, request);
        });
    }

    public void onForwardFailed(String traceId, Throwable error) {
        this.runIfTracingIsEnabled(() -> this.traceInterceptor.onForwardError(traceId, error));
    }

    public void onForwardComplete(String traceId, HttpStatus status, byte[] body, HttpHeaders headers) {
        this.runIfTracingIsEnabled(() -> {
            ReceivedResponse response = new ReceivedResponse();
            response.setStatus(status);
            response.setBody(body);
            response.setHeaders(headers);
            this.traceInterceptor.onForwardComplete(traceId, response);
        });
    }

    protected void runIfTracingIsEnabled(Runnable operation) {
        if (this.charon.getTracing().isEnabled()) {
            operation.run();
        }
    }
}

