/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkopylec.charon.core.http;

import com.github.mkopylec.charon.configuration.CharonProperties;
import com.github.mkopylec.charon.configuration.MappingProperties;
import com.github.mkopylec.charon.core.http.RequestData;
import com.github.mkopylec.charon.core.http.RequestDataExtractor;
import com.github.mkopylec.charon.core.http.RequestForwarder;
import com.github.mkopylec.charon.core.mappings.MappingsProvider;
import com.github.mkopylec.charon.core.trace.ProxyingTraceInterceptor;
import com.github.mkopylec.charon.exceptions.CharonException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.retry.RetryOperations;
import org.springframework.web.filter.OncePerRequestFilter;

public class ReverseProxyFilter
extends OncePerRequestFilter {
    protected static final String X_FORWARDED_FOR_HEADER = "X-Forwarded-For";
    protected static final String X_FORWARDED_PROTO_HEADER = "X-Forwarded-Proto";
    protected static final String X_FORWARDED_HOST_HEADER = "X-Forwarded-Host";
    protected static final String X_FORWARDED_PORT_HEADER = "X-Forwarded-Port";
    private static final Logger log = LoggerFactory.getLogger(ReverseProxyFilter.class);
    protected final CharonProperties charon;
    protected final RetryOperations retryOperations;
    protected final RetryOperations defaultRetryOperations;
    protected final RequestDataExtractor extractor;
    protected final MappingsProvider mappingsProvider;
    protected final TaskExecutor taskExecutor;
    protected final RequestForwarder requestForwarder;
    protected final ProxyingTraceInterceptor traceInterceptor;

    public ReverseProxyFilter(CharonProperties charon, RetryOperations retryOperations, RetryOperations defaultRetryOperations, RequestDataExtractor extractor, MappingsProvider mappingsProvider, TaskExecutor taskExecutor, RequestForwarder requestForwarder, ProxyingTraceInterceptor traceInterceptor) {
        this.charon = charon;
        this.retryOperations = retryOperations;
        this.defaultRetryOperations = defaultRetryOperations;
        this.extractor = extractor;
        this.mappingsProvider = mappingsProvider;
        this.taskExecutor = taskExecutor;
        this.requestForwarder = requestForwarder;
        this.traceInterceptor = traceInterceptor;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String originUri = this.extractor.extractUri(request);
        log.debug("Incoming: {} {}", (Object)request.getMethod(), (Object)originUri);
        HttpHeaders headers = this.extractor.extractHttpHeaders(request);
        HttpMethod method = this.extractor.extractHttpMethod(request);
        String traceId = this.traceInterceptor.generateTraceId();
        this.traceInterceptor.onRequestReceived(traceId, method, originUri, headers);
        MappingProperties mapping = this.mappingsProvider.resolveMapping(originUri, request);
        if (mapping == null) {
            this.traceInterceptor.onNoMappingFound(traceId, method, originUri, headers);
            log.debug("Forwarding: {} {} -> no mapping found", (Object)method, (Object)originUri);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        byte[] body = this.extractor.extractBody(request);
        this.addForwardHeaders(request, headers);
        RequestData dataToForward = new RequestData(method, originUri, headers, body);
        this.forwardToDestination(response, traceId, mapping, dataToForward);
    }

    protected void addForwardHeaders(HttpServletRequest request, HttpHeaders headers) {
        ArrayList<String> forwardedFor = headers.get((Object)X_FORWARDED_FOR_HEADER);
        if (CollectionUtils.isEmpty((Collection)forwardedFor)) {
            forwardedFor = new ArrayList<String>(1);
        }
        forwardedFor.add(request.getRemoteAddr());
        headers.put(X_FORWARDED_FOR_HEADER, forwardedFor);
        headers.set(X_FORWARDED_PROTO_HEADER, request.getScheme());
        headers.set(X_FORWARDED_HOST_HEADER, request.getServerName());
        headers.set(X_FORWARDED_PORT_HEADER, String.valueOf(request.getServerPort()));
    }

    protected void forwardToDestination(HttpServletResponse response, String traceId, MappingProperties mapping, RequestData dataToForward) {
        ResponseEntity responseEntity;
        if (mapping.isAsynchronous()) {
            this.taskExecutor.execute(() -> {
                ResponseEntity cfr_ignored_0 = (ResponseEntity)this.resolveRetryOperations(mapping).execute(context -> {
                    try {
                        return this.requestForwarder.forwardHttpRequest(dataToForward, traceId, context, mapping);
                    }
                    catch (Exception e) {
                        log.error("Error forwarding HTTP request asynchronously", (Throwable)e);
                        return null;
                    }
                });
            });
            responseEntity = new ResponseEntity(HttpStatus.ACCEPTED);
        } else {
            responseEntity = (ResponseEntity)this.resolveRetryOperations(mapping).execute(context -> this.requestForwarder.forwardHttpRequest(dataToForward, traceId, context, mapping));
        }
        this.processResponse(response, (ResponseEntity<byte[]>)responseEntity);
    }

    protected RetryOperations resolveRetryOperations(MappingProperties mapping) {
        return mapping != null && mapping.isRetryable() ? this.retryOperations : this.defaultRetryOperations;
    }

    protected void processResponse(HttpServletResponse response, ResponseEntity<byte[]> responseEntity) {
        response.setStatus(responseEntity.getStatusCode().value());
        responseEntity.getHeaders().forEach((name, values) -> values.forEach(value -> response.addHeader(name, value)));
        if (responseEntity.getBody() != null) {
            try {
                response.getOutputStream().write((byte[])responseEntity.getBody());
            }
            catch (IOException e) {
                throw new CharonException("Error extracting body of HTTP response with status: " + responseEntity.getStatusCode(), e);
            }
        }
    }
}

