/*
 * Decompiled with CFR 0.152.
 */
package com.github.steveice10.mc.auth.service;

import com.github.steveice10.mc.auth.data.GameProfile;
import com.github.steveice10.mc.auth.exception.request.InvalidCredentialsException;
import com.github.steveice10.mc.auth.exception.request.RequestException;
import com.github.steveice10.mc.auth.service.AuthenticationService;
import com.github.steveice10.mc.auth.util.HTTP;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class MojangAuthenticationService
extends AuthenticationService {
    private static final URI DEFAULT_BASE_URI = URI.create("https://authserver.mojang.com/");
    private static final String AUTHENTICATE_ENDPOINT = "authenticate";
    private static final String REFRESH_ENDPOINT = "refresh";
    private static final String INVALIDATE_ENDPOINT = "invalidate";
    private String id;
    private String clientToken;

    public MojangAuthenticationService() {
        this(UUID.randomUUID().toString());
    }

    public MojangAuthenticationService(String clientToken) {
        super(DEFAULT_BASE_URI);
        if (clientToken == null) {
            throw new IllegalArgumentException("ClientToken cannot be null.");
        }
        this.clientToken = clientToken;
    }

    public String getId() {
        return this.id;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    @Override
    public void login() throws RequestException {
        AuthenticateRefreshResponse response;
        boolean password;
        if (this.username == null || this.username.equals("")) {
            throw new InvalidCredentialsException("Invalid username.");
        }
        boolean token = this.accessToken != null && !this.accessToken.equals("");
        boolean bl = password = this.password != null && !this.password.equals("");
        if (!token && !password) {
            throw new InvalidCredentialsException("Invalid password or access token.");
        }
        if (token) {
            RefreshRequest request = new RefreshRequest(this.clientToken, this.accessToken, null);
            response = HTTP.makeRequest(this.getProxy(), this.getEndpointUri(REFRESH_ENDPOINT), request, AuthenticateRefreshResponse.class);
        } else {
            AuthenticationRequest request = new AuthenticationRequest(this.username, this.password, this.clientToken);
            response = HTTP.makeRequest(this.getProxy(), this.getEndpointUri(AUTHENTICATE_ENDPOINT), request, AuthenticateRefreshResponse.class);
        }
        if (response == null) {
            throw new RequestException("Server returned invalid response.");
        }
        if (!response.clientToken.equals(this.clientToken)) {
            throw new RequestException("Server responded with incorrect client token.");
        }
        this.id = response.user != null && response.user.id != null ? response.user.id : this.username;
        this.accessToken = response.accessToken;
        this.profiles = response.availableProfiles != null ? Arrays.asList(response.availableProfiles) : Collections.emptyList();
        this.selectedProfile = response.selectedProfile;
        this.properties.clear();
        if (response.user != null && response.user.properties != null) {
            this.properties.addAll(response.user.properties);
        }
        this.loggedIn = true;
    }

    @Override
    public void logout() throws RequestException {
        InvalidateRequest request = new InvalidateRequest(this.clientToken, this.accessToken);
        HTTP.makeRequest(this.getProxy(), this.getEndpointUri(INVALIDATE_ENDPOINT), request);
        super.logout();
        this.id = null;
    }

    public void selectGameProfile(GameProfile profile) throws RequestException {
        if (!this.loggedIn) {
            throw new RequestException("Cannot change game profile while not logged in.");
        }
        if (this.selectedProfile != null) {
            throw new RequestException("Cannot change game profile when it is already selected.");
        }
        if (profile == null || !this.profiles.contains(profile)) {
            throw new IllegalArgumentException("Invalid profile '" + profile + "'.");
        }
        RefreshRequest request = new RefreshRequest(this.clientToken, this.accessToken, profile);
        AuthenticateRefreshResponse response = HTTP.makeRequest(this.getProxy(), this.getEndpointUri(REFRESH_ENDPOINT), request, AuthenticateRefreshResponse.class);
        if (response == null) {
            throw new RequestException("Server returned invalid response.");
        }
        if (!response.clientToken.equals(this.clientToken)) {
            throw new RequestException("Server responded with incorrect client token.");
        }
        this.accessToken = response.accessToken;
        this.selectedProfile = response.selectedProfile;
    }

    public String toString() {
        return "MojangUserAuthentication{clientToken=" + this.clientToken + ", username=" + this.username + ", accessToken=" + this.accessToken + ", loggedIn=" + this.loggedIn + ", profiles=" + this.profiles + ", selectedProfile=" + this.selectedProfile + "}";
    }

    private static class AuthenticateRefreshResponse {
        public String accessToken;
        public String clientToken;
        public GameProfile selectedProfile;
        public GameProfile[] availableProfiles;
        public User user;

        private AuthenticateRefreshResponse() {
        }
    }

    private static class InvalidateRequest {
        private String clientToken;
        private String accessToken;

        protected InvalidateRequest(String clientToken, String accessToken) {
            this.clientToken = clientToken;
            this.accessToken = accessToken;
        }
    }

    private static class RefreshRequest {
        private String clientToken;
        private String accessToken;
        private GameProfile selectedProfile;
        private boolean requestUser;

        protected RefreshRequest(String clientToken, String accessToken, GameProfile selectedProfile) {
            this.clientToken = clientToken;
            this.accessToken = accessToken;
            this.selectedProfile = selectedProfile;
            this.requestUser = true;
        }
    }

    private static class AuthenticationRequest {
        private Agent agent = new Agent("Minecraft", 1);
        private String username;
        private String password;
        private String clientToken;
        private boolean requestUser;

        protected AuthenticationRequest(String username, String password, String clientToken) {
            this.username = username;
            this.password = password;
            this.clientToken = clientToken;
            this.requestUser = true;
        }
    }

    private static class User {
        public String id;
        public List<GameProfile.Property> properties;

        private User() {
        }
    }

    private static class Agent {
        private String name;
        private int version;

        protected Agent(String name, int version) {
            this.name = name;
            this.version = version;
        }
    }
}

